/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.record.InboxInstance;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.storage.proto.BatchInsertRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InsertRequest;
import org.apache.bifromq.inbox.storage.proto.InsertResult;
import org.apache.bifromq.inbox.storage.proto.SubMessagePack;
import org.apache.bifromq.type.TopicMessagePack;

class BatchInsertCall
extends BatchMutationCall<InsertRequest, InsertResult> {
    protected BatchInsertCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<InsertRequest, InsertResult> newBatch(long ver) {
        return new BatchInsertCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey>> callTasks) {
        BatchInsertRequest.Builder reqBuilder = BatchInsertRequest.newBuilder();
        IdentityHashMap<TopicMessagePack, Integer> poolIndex = new IdentityHashMap<TopicMessagePack, Integer>();
        LinkedList<TopicMessagePack> pool = new LinkedList<TopicMessagePack>();
        LinkedList<BatchInsertRequest.InsertRef> insertRefs = new LinkedList<BatchInsertRequest.InsertRef>();
        for (ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey> call : callTasks) {
            InsertRequest req = (InsertRequest)call.call();
            BatchInsertRequest.InsertRef.Builder refBuilder = BatchInsertRequest.InsertRef.newBuilder().setTenantId(req.getTenantId()).setInboxId(req.getInboxId()).setIncarnation(req.getIncarnation());
            for (SubMessagePack subPack : req.getMessagePackList()) {
                TopicMessagePack msgPack = subPack.getMessages();
                Integer idx = (Integer)poolIndex.get(msgPack);
                if (idx == null) {
                    idx = pool.size();
                    poolIndex.put(msgPack, idx);
                    pool.add(msgPack);
                }
                BatchInsertRequest.SubRef.Builder subRef = BatchInsertRequest.SubRef.newBuilder().addAllMatchedRoute((Iterable)subPack.getMatchedRouteList()).setMessagePackIndex(idx.intValue());
                refBuilder.addSubRef(subRef.build());
            }
            insertRefs.add(refBuilder.build());
        }
        reqBuilder.addAllTopicMessagePack(pool);
        reqBuilder.addAllInsertRef(insertRefs);
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchInsert(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchInsert().getResultCount());
        int i = 0;
        while ((task = batchedTasks.poll()) != null) {
            task.resultPromise().complete(output.getInboxService().getBatchInsert().getResult(i++));
        }
    }

    protected void handleException(ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey> callTask, Throwable e) {
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchInsertCallTask
    extends BatchMutationCall.MutationCallTaskBatch<InsertRequest, InsertResult> {
        private final Set<TenantInboxInstance> inboxes = new HashSet<TenantInboxInstance>();

        private BatchInsertCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.add(new TenantInboxInstance(((InsertRequest)callTask.call()).getTenantId(), new InboxInstance(((InsertRequest)callTask.call()).getInboxId(), ((InsertRequest)callTask.call()).getIncarnation())));
        }

        protected boolean isBatchable(ICallTask<InsertRequest, InsertResult, MutationCallBatcherKey> callTask) {
            return !this.inboxes.contains(new TenantInboxInstance(((InsertRequest)callTask.call()).getTenantId(), new InboxInstance(((InsertRequest)callTask.call()).getInboxId(), ((InsertRequest)callTask.call()).getIncarnation())));
        }
    }
}

