/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store;

import com.google.protobuf.Struct;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.retain.store.IRetainStore;
import org.apache.bifromq.retain.store.RetainStore;

public class RetainStoreBuilder {
    String clusterId = "retain.store";
    RPCServerBuilder rpcServerBuilder;
    IAgentHost agentHost;
    IBaseKVMetaService metaService;
    IBaseKVStoreClient retainStoreClient;
    KVRangeStoreOptions storeOptions;
    int workerThreads;
    int tickerThreads;
    ScheduledExecutorService bgTaskExecutor;
    Duration bootstrapDelay = Duration.ofSeconds(15L);
    Duration zombieProbeDelay = Duration.ofSeconds(15L);
    Duration balancerRetryDelay = Duration.ofSeconds(5L);
    Map<String, Struct> balancerFactoryConfig = new HashMap<String, Struct>();
    Duration gcInterval = Duration.ofMinutes(60L);
    Map<String, String> attributes = new HashMap<String, String>();

    public IRetainStore build() {
        return new RetainStore(this);
    }

    @Generated
    RetainStoreBuilder() {
    }

    @Generated
    public RetainStoreBuilder clusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Generated
    public RetainStoreBuilder rpcServerBuilder(RPCServerBuilder rpcServerBuilder) {
        this.rpcServerBuilder = rpcServerBuilder;
        return this;
    }

    @Generated
    public RetainStoreBuilder agentHost(IAgentHost agentHost) {
        this.agentHost = agentHost;
        return this;
    }

    @Generated
    public RetainStoreBuilder metaService(IBaseKVMetaService metaService) {
        this.metaService = metaService;
        return this;
    }

    @Generated
    public RetainStoreBuilder retainStoreClient(IBaseKVStoreClient retainStoreClient) {
        this.retainStoreClient = retainStoreClient;
        return this;
    }

    @Generated
    public RetainStoreBuilder storeOptions(KVRangeStoreOptions storeOptions) {
        this.storeOptions = storeOptions;
        return this;
    }

    @Generated
    public RetainStoreBuilder workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Generated
    public RetainStoreBuilder tickerThreads(int tickerThreads) {
        this.tickerThreads = tickerThreads;
        return this;
    }

    @Generated
    public RetainStoreBuilder bgTaskExecutor(ScheduledExecutorService bgTaskExecutor) {
        this.bgTaskExecutor = bgTaskExecutor;
        return this;
    }

    @Generated
    public RetainStoreBuilder bootstrapDelay(Duration bootstrapDelay) {
        this.bootstrapDelay = bootstrapDelay;
        return this;
    }

    @Generated
    public RetainStoreBuilder zombieProbeDelay(Duration zombieProbeDelay) {
        this.zombieProbeDelay = zombieProbeDelay;
        return this;
    }

    @Generated
    public RetainStoreBuilder balancerRetryDelay(Duration balancerRetryDelay) {
        this.balancerRetryDelay = balancerRetryDelay;
        return this;
    }

    @Generated
    public RetainStoreBuilder balancerFactoryConfig(Map<String, Struct> balancerFactoryConfig) {
        this.balancerFactoryConfig = balancerFactoryConfig;
        return this;
    }

    @Generated
    public RetainStoreBuilder gcInterval(Duration gcInterval) {
        this.gcInterval = gcInterval;
        return this;
    }

    @Generated
    public RetainStoreBuilder attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }
}

