/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.server;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.sessiondict.RPCBluePrint;
import org.apache.bifromq.sessiondict.server.ISessionDictServer;
import org.apache.bifromq.sessiondict.server.SessionDictServerBuilder;
import org.apache.bifromq.sessiondict.server.SessionDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionDictServer
implements ISessionDictServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionDictServer.class);
    private final SessionDictService service;
    private final ExecutorService rpcExecutor;

    SessionDictServer(SessionDictServerBuilder builder) {
        this.service = new SessionDictService(builder.mqttBrokerClient, builder.inboxClient);
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("dist-server-executor")), (String)"dist-server-executor", (Tag[])new Tag[0]);
        builder.rpcServerBuilder.bindService(this.service.bindService(), RPCBluePrint.INSTANCE, builder.attributes, builder.defaultGroupTags, (Executor)this.rpcExecutor);
    }

    @Override
    public void close() {
        log.debug("Closing session dict service");
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.service.close();
    }
}

