package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The limits for an individual tile matrix of a TileSet&#39;s TileMatrixSet, as defined in the OGC 2D TileMatrixSet and TileSet Metadata Standard
 **/
@ApiModel(description = "The limits for an individual tile matrix of a TileSet's TileMatrixSet, as defined in the OGC 2D TileMatrixSet and TileSet Metadata Standard")
@JsonTypeName("tileMatrixLimits")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TileMatrixLimits   {
  private @Valid String tileMatrix;
  private @Valid Integer minTileRow;
  private @Valid Integer maxTileRow;
  private @Valid Integer minTileCol;
  private @Valid Integer maxTileCol;

  /**
   **/
  public TileMatrixLimits tileMatrix(String tileMatrix) {
    this.tileMatrix = tileMatrix;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("tileMatrix")
  @NotNull
  public String getTileMatrix() {
    return tileMatrix;
  }

  @JsonProperty("tileMatrix")
  public void setTileMatrix(String tileMatrix) {
    this.tileMatrix = tileMatrix;
  }

  /**
   * minimum: 0
   **/
  public TileMatrixLimits minTileRow(Integer minTileRow) {
    this.minTileRow = minTileRow;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("minTileRow")
  @NotNull
 @Min(0)  public Integer getMinTileRow() {
    return minTileRow;
  }

  @JsonProperty("minTileRow")
  public void setMinTileRow(Integer minTileRow) {
    this.minTileRow = minTileRow;
  }

  /**
   * minimum: 0
   **/
  public TileMatrixLimits maxTileRow(Integer maxTileRow) {
    this.maxTileRow = maxTileRow;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("maxTileRow")
  @NotNull
 @Min(0)  public Integer getMaxTileRow() {
    return maxTileRow;
  }

  @JsonProperty("maxTileRow")
  public void setMaxTileRow(Integer maxTileRow) {
    this.maxTileRow = maxTileRow;
  }

  /**
   * minimum: 0
   **/
  public TileMatrixLimits minTileCol(Integer minTileCol) {
    this.minTileCol = minTileCol;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("minTileCol")
  @NotNull
 @Min(0)  public Integer getMinTileCol() {
    return minTileCol;
  }

  @JsonProperty("minTileCol")
  public void setMinTileCol(Integer minTileCol) {
    this.minTileCol = minTileCol;
  }

  /**
   * minimum: 0
   **/
  public TileMatrixLimits maxTileCol(Integer maxTileCol) {
    this.maxTileCol = maxTileCol;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("maxTileCol")
  @NotNull
 @Min(0)  public Integer getMaxTileCol() {
    return maxTileCol;
  }

  @JsonProperty("maxTileCol")
  public void setMaxTileCol(Integer maxTileCol) {
    this.maxTileCol = maxTileCol;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileMatrixLimits tileMatrixLimits = (TileMatrixLimits) o;
    return Objects.equals(this.tileMatrix, tileMatrixLimits.tileMatrix) &&
        Objects.equals(this.minTileRow, tileMatrixLimits.minTileRow) &&
        Objects.equals(this.maxTileRow, tileMatrixLimits.maxTileRow) &&
        Objects.equals(this.minTileCol, tileMatrixLimits.minTileCol) &&
        Objects.equals(this.maxTileCol, tileMatrixLimits.maxTileCol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tileMatrix, minTileRow, maxTileRow, minTileCol, maxTileCol);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileMatrixLimits {\n");
    
    sb.append("    tileMatrix: ").append(toIndentedString(tileMatrix)).append("\n");
    sb.append("    minTileRow: ").append(toIndentedString(minTileRow)).append("\n");
    sb.append("    maxTileRow: ").append(toIndentedString(maxTileRow)).append("\n");
    sb.append("    minTileCol: ").append(toIndentedString(minTileCol)).append("\n");
    sb.append("    maxTileCol: ").append(toIndentedString(maxTileCol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

