package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Dates;
import org.apache.baremaps.ogcapi.model.Link1;
import org.apache.baremaps.ogcapi.model.StyleLayer;
import org.apache.baremaps.ogcapi.model.Stylesheet;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("style-metadata")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class StyleMetadata   {
  private @Valid String id;
  private @Valid String title;
  private @Valid String description;
  private @Valid List<String> keywords = null;
  private @Valid String pointOfContact;
  public enum AccessConstraintsEnum {

    UNCLASSIFIED(String.valueOf("unclassified")), CONFIDENTIAL(String.valueOf("confidential")), RESTRICTED(String.valueOf("restricted")), SECRET(String.valueOf("secret")), TOPSECRET(String.valueOf("topSecret"));


    private String value;

    AccessConstraintsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static AccessConstraintsEnum fromString(String s) {
        for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        return null;
	}
	
    @JsonCreator
    public static AccessConstraintsEnum fromValue(String value) {
        for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return null;
    }
}

  private @Valid AccessConstraintsEnum accessConstraints;
  private @Valid Dates dates;
  public enum ScopeEnum {

    STYLE(String.valueOf("style"));


    private String value;

    ScopeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static ScopeEnum fromString(String s) {
        for (ScopeEnum b : ScopeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        return null;
	}
	
    @JsonCreator
    public static ScopeEnum fromValue(String value) {
        for (ScopeEnum b : ScopeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return null;
    }
}

  private @Valid ScopeEnum scope;
  private @Valid String version;
  private @Valid List<Stylesheet> stylesheets = null;
  private @Valid List<StyleLayer> layers = null;
  private @Valid List<Link1> links = null;

  /**
   **/
  public StyleMetadata id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   **/
  public StyleMetadata title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public StyleMetadata description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public StyleMetadata keywords(List<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("keywords")
  public List<String> getKeywords() {
    return keywords;
  }

  @JsonProperty("keywords")
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  public StyleMetadata addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }

    this.keywords.add(keywordsItem);
    return this;
  }

  public StyleMetadata removeKeywordsItem(String keywordsItem) {
    if (keywordsItem != null && this.keywords != null) {
      this.keywords.remove(keywordsItem);
    }

    return this;
  }
  /**
   **/
  public StyleMetadata pointOfContact(String pointOfContact) {
    this.pointOfContact = pointOfContact;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("pointOfContact")
  public String getPointOfContact() {
    return pointOfContact;
  }

  @JsonProperty("pointOfContact")
  public void setPointOfContact(String pointOfContact) {
    this.pointOfContact = pointOfContact;
  }

  /**
   **/
  public StyleMetadata accessConstraints(AccessConstraintsEnum accessConstraints) {
    this.accessConstraints = accessConstraints;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("accessConstraints")
  public AccessConstraintsEnum getAccessConstraints() {
    return accessConstraints;
  }

  @JsonProperty("accessConstraints")
  public void setAccessConstraints(AccessConstraintsEnum accessConstraints) {
    this.accessConstraints = accessConstraints;
  }

  /**
   **/
  public StyleMetadata dates(Dates dates) {
    this.dates = dates;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("dates")
  public Dates getDates() {
    return dates;
  }

  @JsonProperty("dates")
  public void setDates(Dates dates) {
    this.dates = dates;
  }

  /**
   **/
  public StyleMetadata scope(ScopeEnum scope) {
    this.scope = scope;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("scope")
  public ScopeEnum getScope() {
    return scope;
  }

  @JsonProperty("scope")
  public void setScope(ScopeEnum scope) {
    this.scope = scope;
  }

  /**
   **/
  public StyleMetadata version(String version) {
    this.version = version;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  @JsonProperty("version")
  public void setVersion(String version) {
    this.version = version;
  }

  /**
   **/
  public StyleMetadata stylesheets(List<Stylesheet> stylesheets) {
    this.stylesheets = stylesheets;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("stylesheets")
  public List<Stylesheet> getStylesheets() {
    return stylesheets;
  }

  @JsonProperty("stylesheets")
  public void setStylesheets(List<Stylesheet> stylesheets) {
    this.stylesheets = stylesheets;
  }

  public StyleMetadata addStylesheetsItem(Stylesheet stylesheetsItem) {
    if (this.stylesheets == null) {
      this.stylesheets = new ArrayList<>();
    }

    this.stylesheets.add(stylesheetsItem);
    return this;
  }

  public StyleMetadata removeStylesheetsItem(Stylesheet stylesheetsItem) {
    if (stylesheetsItem != null && this.stylesheets != null) {
      this.stylesheets.remove(stylesheetsItem);
    }

    return this;
  }
  /**
   **/
  public StyleMetadata layers(List<StyleLayer> layers) {
    this.layers = layers;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("layers")
  public List<StyleLayer> getLayers() {
    return layers;
  }

  @JsonProperty("layers")
  public void setLayers(List<StyleLayer> layers) {
    this.layers = layers;
  }

  public StyleMetadata addLayersItem(StyleLayer layersItem) {
    if (this.layers == null) {
      this.layers = new ArrayList<>();
    }

    this.layers.add(layersItem);
    return this;
  }

  public StyleMetadata removeLayersItem(StyleLayer layersItem) {
    if (layersItem != null && this.layers != null) {
      this.layers.remove(layersItem);
    }

    return this;
  }
  /**
   * The links may reference related resources. It is recommended to include a link to a thumbnail with link relation &#x60;preview&#x60; (specified by RFC 6903) and the appropriate media type in the &#x60;type&#x60; parameter. The thumbnail may be an image that is published as a resource in the API, it may reference an appropriate raster tile, a map request, etc.
   **/
  public StyleMetadata links(List<Link1> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "The links may reference related resources. It is recommended to include a link to a thumbnail with link relation `preview` (specified by RFC 6903) and the appropriate media type in the `type` parameter. The thumbnail may be an image that is published as a resource in the API, it may reference an appropriate raster tile, a map request, etc.")
  @JsonProperty("links")
  public List<Link1> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link1> links) {
    this.links = links;
  }

  public StyleMetadata addLinksItem(Link1 linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public StyleMetadata removeLinksItem(Link1 linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StyleMetadata styleMetadata = (StyleMetadata) o;
    return Objects.equals(this.id, styleMetadata.id) &&
        Objects.equals(this.title, styleMetadata.title) &&
        Objects.equals(this.description, styleMetadata.description) &&
        Objects.equals(this.keywords, styleMetadata.keywords) &&
        Objects.equals(this.pointOfContact, styleMetadata.pointOfContact) &&
        Objects.equals(this.accessConstraints, styleMetadata.accessConstraints) &&
        Objects.equals(this.dates, styleMetadata.dates) &&
        Objects.equals(this.scope, styleMetadata.scope) &&
        Objects.equals(this.version, styleMetadata.version) &&
        Objects.equals(this.stylesheets, styleMetadata.stylesheets) &&
        Objects.equals(this.layers, styleMetadata.layers) &&
        Objects.equals(this.links, styleMetadata.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, description, keywords, pointOfContact, accessConstraints, dates, scope, version, stylesheets, layers, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StyleMetadata {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    pointOfContact: ").append(toIndentedString(pointOfContact)).append("\n");
    sb.append("    accessConstraints: ").append(toIndentedString(accessConstraints)).append("\n");
    sb.append("    dates: ").append(toIndentedString(dates)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    stylesheets: ").append(toIndentedString(stylesheets)).append("\n");
    sb.append("    layers: ").append(toIndentedString(layers)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

