/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.geocoder;

import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Application;
import org.apache.baremaps.server.ClassPathResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.GeocoderResource;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start a tile server with caching capabilities."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Option(names={"--index"}, paramLabel="INDEX", description={"The path to the lucene index."}, required=true)
    private Path indexDirectory;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        try (FSDirectory directory = MMapDirectory.open((Path)this.indexDirectory);
             final SearcherManager searcherManager = new SearcherManager((Directory)directory, new SearcherFactory());){
            ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(GeocoderResource.class).register(ClassPathResource.class).register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bind("geocoder").to(String.class).named("directory");
                    this.bind("index.html").to(String.class).named("index");
                    this.bind(searcherManager).to(SearcherManager.class).named("searcherManager");
                }
            });
            BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
            HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
            logger.info("Listening on {}", (Object)serverContext.listenAddress());
            serverContext.awaitShutdown();
        }
        return 0;
    }
}

