/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.row;

import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.constants.ObjectIdentifier;
import de.bytefish.pgbulkinsert.pgsql.handlers.CollectionValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.RangeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Box;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Circle;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Line;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.LineSegment;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Path;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Point;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Polygon;
import de.bytefish.pgbulkinsert.pgsql.model.network.MacAddress;
import de.bytefish.pgbulkinsert.pgsql.model.range.Range;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SimpleRow {
    private final ValueHandlerProvider provider;
    private final Map<String, Integer> lookup;
    private final Map<Integer, Consumer<PgBinaryWriter>> actions;
    private final Function<String, String> nullCharacterHandler;

    public SimpleRow(ValueHandlerProvider provider, Map<String, Integer> lookup, Function<String, String> nullCharacterHandler) {
        this.provider = provider;
        this.lookup = lookup;
        this.actions = new HashMap<Integer, Consumer<PgBinaryWriter>>();
        this.nullCharacterHandler = nullCharacterHandler;
    }

    public <TTargetType> void setValue(String columnName, DataType type, TTargetType value) {
        int ordinal = Objects.requireNonNull(this.lookup.get(columnName), columnName + " not found");
        this.setValue(ordinal, type, value);
    }

    public <TTargetType> void setValue(int ordinal, DataType type, TTargetType value) {
        IValueHandler handler = this.provider.resolve(type);
        this.actions.put(ordinal, writer -> writer.write(handler, value));
    }

    public <TTargetType> void setValue(String columnName, IValueHandler<TTargetType> handler, TTargetType value) {
        int ordinal = Objects.requireNonNull(this.lookup.get(columnName), columnName + " not found");
        this.setValue(ordinal, handler, value);
    }

    public <TTargetType> void setValue(int ordinal, IValueHandler<TTargetType> handler, TTargetType value) {
        this.actions.put(ordinal, writer -> writer.write(handler, value));
    }

    public <TElementType, TCollectionType extends Collection<TElementType>> void setCollection(String columnName, DataType type, TCollectionType value) {
        int ordinal = Objects.requireNonNull(this.lookup.get(columnName), columnName + " not found");
        this.setCollection(ordinal, type, value);
    }

    public <TElementType, TCollectionType extends Collection<TElementType>> void setCollection(int ordinal, DataType type, TCollectionType value) {
        CollectionValueHandler handler = new CollectionValueHandler(ObjectIdentifier.mapFrom(type), this.provider.resolve(type));
        this.actions.put(ordinal, writer -> writer.write(handler, value));
    }

    public void writeRow(PgBinaryWriter writer) {
        for (int ordinalIdx = 0; ordinalIdx < this.lookup.keySet().size(); ++ordinalIdx) {
            Consumer<PgBinaryWriter> action = this.actions.get(ordinalIdx);
            if (action == null) {
                writer.writeNull();
                continue;
            }
            action.accept(writer);
        }
    }

    public void setBoolean(String columnName, Boolean value) {
        this.setValue(columnName, DataType.Boolean, value);
    }

    public void setBoolean(int ordinal, Boolean value) {
        this.setValue(ordinal, DataType.Boolean, value);
    }

    public void setByte(String columnName, Byte value) {
        this.setValue(columnName, DataType.Char, value);
    }

    public void setByte(int ordinal, Byte value) {
        this.setValue(ordinal, DataType.Char, value);
    }

    public void setShort(String columnName, Short value) {
        this.setValue(columnName, DataType.Int2, value);
    }

    public void setShort(int ordinal, Short value) {
        this.setValue(ordinal, DataType.Int2, value);
    }

    public void setInteger(String columnName, Integer value) {
        this.setValue(columnName, DataType.Int4, value);
    }

    public void setInteger(int ordinal, Integer value) {
        this.setValue(ordinal, DataType.Int4, value);
    }

    public void setNumeric(String columnName, Number value) {
        this.setValue(columnName, DataType.Numeric, value);
    }

    public void setNumeric(int ordinal, Number value) {
        this.setValue(ordinal, DataType.Numeric, value);
    }

    public void setLong(String columnName, Long value) {
        this.setValue(columnName, DataType.Int8, value);
    }

    public void setLong(int ordinal, Long value) {
        this.setValue(ordinal, DataType.Int8, value);
    }

    public void setFloat(String columnName, Float value) {
        this.setValue(columnName, DataType.SinglePrecision, value);
    }

    public void setFloat(int ordinal, Float value) {
        this.setValue(ordinal, DataType.SinglePrecision, value);
    }

    public void setDouble(String columnName, Double value) {
        this.setValue(columnName, DataType.DoublePrecision, value);
    }

    public void setDouble(int ordinal, Double value) {
        this.setValue(ordinal, DataType.DoublePrecision, value);
    }

    protected void setTime(String columnName, LocalTime value) {
        this.setValue(columnName, DataType.Time, value);
    }

    protected void setTime(int ordinal, LocalTime value) {
        this.setValue(ordinal, DataType.Time, value);
    }

    public void setDate(String columnName, LocalDate value) {
        this.setValue(columnName, DataType.Date, value);
    }

    public void setDate(int ordinal, LocalDate value) {
        this.setValue(ordinal, DataType.Date, value);
    }

    public void setTimeStamp(String columnName, LocalDateTime value) {
        this.setValue(columnName, DataType.Timestamp, value);
    }

    public void setTimeStamp(int ordinal, LocalDateTime value) {
        this.setValue(ordinal, DataType.Timestamp, value);
    }

    public void setTimeStampTz(String columnName, ZonedDateTime value) {
        this.setValue(columnName, DataType.TimestampTz, value);
    }

    public void setTimeStampTz(int ordinal, ZonedDateTime value) {
        this.setValue(ordinal, DataType.TimestampTz, value);
    }

    public void setInet6Addr(String columnName, Inet6Address value) {
        this.setValue(columnName, DataType.Inet6, value);
    }

    public void setInet6Addr(int ordinal, Inet6Address value) {
        this.setValue(ordinal, DataType.Inet6, value);
    }

    public void setInet4Addr(String columnName, Inet4Address value) {
        this.setValue(columnName, DataType.Inet4, value);
    }

    public void setInet4Addr(int ordinal, Inet4Address value) {
        this.setValue(ordinal, DataType.Inet4, value);
    }

    public void setMacAddress(String columnName, MacAddress value) {
        this.setValue(columnName, DataType.MacAddress, value);
    }

    public void setMacAddress(int ordinal, MacAddress value) {
        this.setValue(ordinal, DataType.MacAddress, value);
    }

    public void setText(String columnName, String value) {
        this.setValue(columnName, DataType.Text, this.nullCharacterHandler.apply(value));
    }

    public void setText(int ordinal, String value) {
        this.setValue(ordinal, DataType.Text, this.nullCharacterHandler.apply(value));
    }

    public void setVarChar(String columnName, String value) {
        this.setValue(columnName, DataType.Text, this.nullCharacterHandler.apply(value));
    }

    public void setVarChar(int ordinal, String value) {
        this.setValue(ordinal, DataType.Text, this.nullCharacterHandler.apply(value));
    }

    public void setUUID(String columnName, UUID value) {
        this.setValue(columnName, DataType.Uuid, value);
    }

    public void setUUID(int ordinal, UUID value) {
        this.setValue(ordinal, DataType.Uuid, value);
    }

    public void setJsonb(String columnName, String value) {
        this.setValue(columnName, DataType.Jsonb, this.nullCharacterHandler.apply(value));
    }

    public void setJsonb(int ordinal, String value) {
        this.setValue(ordinal, DataType.Jsonb, this.nullCharacterHandler.apply(value));
    }

    public void setHstore(String columnName, Map<String, String> value) {
        this.setValue(columnName, DataType.Hstore, value);
    }

    public void setHstore(int ordinal, Map<String, String> value) {
        this.setValue(ordinal, DataType.Hstore, value);
    }

    public void setPoint(String columnName, Point value) {
        this.setValue(columnName, DataType.Point, value);
    }

    public void setPoint(int ordinal, Point value) {
        this.setValue(ordinal, DataType.Point, value);
    }

    public void setBox(String columnName, Box value) {
        this.setValue(columnName, DataType.Box, value);
    }

    public void setBox(int ordinal, Box value) {
        this.setValue(ordinal, DataType.Box, value);
    }

    public void setPath(String columnName, Path value) {
        this.setValue(columnName, DataType.Path, value);
    }

    public void setPath(int ordinal, Path value) {
        this.setValue(ordinal, DataType.Path, value);
    }

    public void setPolygon(String columnName, Polygon value) {
        this.setValue(columnName, DataType.Polygon, value);
    }

    public void setPolygon(int ordinal, Polygon value) {
        this.setValue(ordinal, DataType.Polygon, value);
    }

    public void setLine(String columnName, Line value) {
        this.setValue(columnName, DataType.Line, value);
    }

    public void setLine(int ordinal, Line value) {
        this.setValue(ordinal, DataType.Line, value);
    }

    public void setLineSegment(String columnName, LineSegment value) {
        this.setValue(columnName, DataType.LineSegment, value);
    }

    public void setLineSegment(int ordinal, LineSegment value) {
        this.setValue(ordinal, DataType.LineSegment, value);
    }

    public void setCircle(String columnName, Circle value) {
        this.setValue(columnName, DataType.Circle, value);
    }

    public void setCircle(int ordinal, Circle value) {
        this.setValue(ordinal, DataType.Circle, value);
    }

    public void setByteArray(String columnName, byte[] value) {
        this.setValue(columnName, DataType.Bytea, value);
    }

    public void setByteArray(int ordinal, byte[] value) {
        this.setValue(ordinal, DataType.Bytea, value);
    }

    public void setBooleanArray(String columnName, Collection<Boolean> value) {
        this.setCollection(columnName, DataType.Boolean, value);
    }

    public void setBooleanArray(int ordinal, Collection<Boolean> value) {
        this.setCollection(ordinal, DataType.Boolean, value);
    }

    public <T extends Number> void setShortArray(String columnName, Collection<T> value) {
        this.setCollection(columnName, DataType.Int2, value);
    }

    public <T extends Number> void setShortArray(int ordinal, Collection<T> value) {
        this.setCollection(ordinal, DataType.Int2, value);
    }

    public <T extends Number> void setIntegerArray(String columnName, Collection<T> value) {
        this.setCollection(columnName, DataType.Int4, value);
    }

    public <T extends Number> void setIntegerArray(int ordinal, Collection<T> value) {
        this.setCollection(ordinal, DataType.Int4, value);
    }

    public <T extends Number> void setLongArray(String columnName, Collection<T> value) {
        this.setCollection(columnName, DataType.Int8, value);
    }

    public <T extends Number> void setLongArray(int ordinal, Collection<T> value) {
        this.setCollection(ordinal, DataType.Int8, value);
    }

    public void setTextArray(String columnName, Collection<String> value) {
        Collection values = value.stream().map(x -> this.nullCharacterHandler.apply((String)x)).collect(Collectors.toList());
        this.setCollection(columnName, DataType.Text, values);
    }

    public void setTextArray(int ordinal, Collection<String> value) {
        Collection values = value.stream().map(x -> this.nullCharacterHandler.apply((String)x)).collect(Collectors.toList());
        this.setCollection(ordinal, DataType.Text, values);
    }

    public void setVarCharArray(String columnName, Collection<String> value) {
        Collection values = value.stream().map(x -> this.nullCharacterHandler.apply((String)x)).collect(Collectors.toList());
        this.setCollection(columnName, DataType.VarChar, values);
    }

    public void setVarCharArray(int ordinal, Collection<String> value) {
        Collection values = value.stream().map(x -> this.nullCharacterHandler.apply((String)x)).collect(Collectors.toList());
        this.setCollection(ordinal, DataType.VarChar, values);
    }

    public <T extends Number> void setFloatArray(String columnName, Collection<T> value) {
        this.setCollection(columnName, DataType.SinglePrecision, value);
    }

    public <T extends Number> void setFloatArray(int ordinal, Collection<T> value) {
        this.setCollection(ordinal, DataType.SinglePrecision, value);
    }

    public <T extends Number> void setDoubleArray(String columnName, Collection<T> value) {
        this.setCollection(columnName, DataType.DoublePrecision, value);
    }

    public <T extends Number> void setDoubleArray(int ordinal, Collection<T> value) {
        this.setCollection(ordinal, DataType.DoublePrecision, value);
    }

    public <T extends Number> void setNumericArray(String columnName, Collection<T> value) {
        this.setCollection(columnName, DataType.Numeric, value);
    }

    public <T extends Number> void setNumericArray(int ordinal, Collection<T> value) {
        this.setCollection(ordinal, DataType.Numeric, value);
    }

    public void setUUIDArray(String columnName, Collection<UUID> value) {
        this.setCollection(columnName, DataType.Uuid, value);
    }

    public void setUUIDArray(int ordinal, Collection<UUID> value) {
        this.setCollection(ordinal, DataType.Uuid, value);
    }

    public void setInet4Array(String columnName, Collection<Inet4Address> value) {
        this.setCollection(columnName, DataType.Inet4, value);
    }

    public void setInet4Array(int ordinal, Collection<Inet4Address> value) {
        this.setCollection(ordinal, DataType.Inet4, value);
    }

    public void setInet6Array(String columnName, Collection<Inet6Address> value) {
        this.setCollection(columnName, DataType.Inet6, value);
    }

    public void setInet6Array(int ordinal, Collection<Inet6Address> value) {
        this.setCollection(ordinal, DataType.Inet6, value);
    }

    public <TElementType> void setRange(String columnName, DataType dataType, Range<TElementType> value) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        this.setValue(columnName, new RangeValueHandler(valueHandler), value);
    }

    public <TElementType> void setRange(int ordinal, DataType dataType, Range<TElementType> value) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        this.setValue(ordinal, new RangeValueHandler(valueHandler), value);
    }

    public void setTsRange(String columnName, Range<LocalDateTime> value) {
        this.setValue(columnName, DataType.TsRange, value);
    }

    public void setTsRange(int ordinal, Range<LocalDateTime> value) {
        this.setValue(ordinal, DataType.TsRange, value);
    }

    public void setTsTzRange(String columnName, Range<ZonedDateTime> value) {
        this.setValue(columnName, DataType.TsTzRange, value);
    }

    public void setTsTzRange(int ordinal, Range<ZonedDateTime> value) {
        this.setValue(ordinal, DataType.TsTzRange, value);
    }

    public void setInt4Range(String columnName, Range<Integer> value) {
        this.setValue(columnName, DataType.Int4Range, value);
    }

    public void setInt4Range(int ordinal, Range<Integer> value) {
        this.setValue(ordinal, DataType.Int4Range, value);
    }

    public void setInt8Range(String columnName, Range<Long> value) {
        this.setValue(columnName, DataType.Int8Range, value);
    }

    public void setInt8Range(int ordinal, Range<Long> value) {
        this.setValue(ordinal, DataType.Int8Range, value);
    }

    public void setNumRange(String columnName, Range<Number> value) {
        this.setValue(columnName, DataType.NumRange, value);
    }

    public void setNumRange(int ordinal, Range<Number> value) {
        this.setValue(ordinal, DataType.NumRange, value);
    }

    public void setDateRange(String columnName, Range<LocalDate> value) {
        this.setValue(columnName, DataType.DateRange, value);
    }

    public void setDateRange(int ordinal, Range<LocalDate> value) {
        this.setValue(ordinal, DataType.DateRange, value);
    }
}

