/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSFrameSlot;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceElementsNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import com.oracle.truffle.js.nodes.function.DefineMethodNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.nodes.function.NamedEvaluationTargetNode;
import com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import java.util.Set;

public final class ClassDefinitionNode
extends NamedEvaluationTargetNode
implements FunctionNameHolder,
ResumableNode.WithObjectState {
    private final JSContext context;
    @Node.Child
    private JavaScriptNode constructorFunctionNode;
    @Node.Child
    private JavaScriptNode classHeritageNode;
    @Node.Children
    private final ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes;
    @Node.Child
    private JSWriteFrameSlotNode writeClassBindingNode;
    @Node.Child
    private JSWriteFrameSlotNode writeInternalConstructorBrand;
    @Node.Child
    private PropertyGetNode getPrototypeNode;
    @Node.Child
    private CreateMethodPropertyNode setConstructorNode;
    @Node.Child
    private CreateObjectNode.CreateObjectWithPrototypeNode createPrototypeNode;
    @Node.Child
    private DefineMethodNode defineConstructorMethodNode;
    @Node.Child
    private PropertySetNode setFieldsNode;
    @Node.Child
    private InitializeInstanceElementsNode staticElementsNode;
    @Node.Child
    private PropertySetNode setPrivateBrandNode;
    @Node.Child
    private SetFunctionNameNode setFunctionName;
    @Node.Child
    private IsConstructorNode isConstructorNode;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final boolean hasName;
    private final int instanceFieldCount;
    private final int staticElementCount;

    protected ClassDefinitionNode(JSContext context, JSFunctionExpressionNode constructorFunctionNode, JavaScriptNode classHeritageNode, ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes, JSWriteFrameSlotNode writeClassBindingNode, JSWriteFrameSlotNode writeInternalConstructorBrand, boolean hasName, int instanceFieldCount, int staticElementCount, boolean hasPrivateInstanceMethods, int blockScopeSlot) {
        this.context = context;
        this.constructorFunctionNode = constructorFunctionNode;
        this.classHeritageNode = classHeritageNode;
        this.memberNodes = memberNodes;
        this.hasName = hasName;
        this.instanceFieldCount = instanceFieldCount;
        this.staticElementCount = staticElementCount;
        this.writeClassBindingNode = writeClassBindingNode;
        this.writeInternalConstructorBrand = writeInternalConstructorBrand;
        this.getPrototypeNode = PropertyGetNode.create(JSObject.PROTOTYPE, false, context);
        this.setConstructorNode = CreateMethodPropertyNode.create(context, JSObject.CONSTRUCTOR);
        this.createPrototypeNode = CreateObjectNode.createOrdinaryWithPrototype(context);
        this.defineConstructorMethodNode = DefineMethodNode.create(context, constructorFunctionNode, blockScopeSlot);
        this.setFieldsNode = instanceFieldCount != 0 ? PropertySetNode.createSetHidden(JSFunction.CLASS_FIELDS_ID, context) : null;
        this.setPrivateBrandNode = hasPrivateInstanceMethods ? PropertySetNode.createSetHidden(JSFunction.PRIVATE_BRAND_ID, context) : null;
        this.setFunctionName = hasName ? null : SetFunctionNameNode.create();
        this.isConstructorNode = IsConstructorNode.create();
    }

    public static ClassDefinitionNode create(JSContext context, JSFunctionExpressionNode constructorFunction, JavaScriptNode classHeritage, ObjectLiteralNode.ObjectLiteralMemberNode[] members, JSWriteFrameSlotNode writeClassBinding, JSWriteFrameSlotNode writeInternalConstructorBrand, boolean hasName, int instanceFieldCount, int staticFieldCount, boolean hasPrivateInstanceMethods, JSFrameSlot blockScopeSlot) {
        return new ClassDefinitionNode(context, constructorFunction, classHeritage, members, writeClassBinding, writeInternalConstructorBrand, hasName, instanceFieldCount, staticFieldCount, hasPrivateInstanceMethods, blockScopeSlot != null ? blockScopeSlot.getIndex() : -1);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeWithName(frame, null);
    }

    @Override
    public Object resume(VirtualFrame frame, int stateSlot) {
        Object maybeState = this.getState(frame, stateSlot);
        ClassDefinitionResumptionRecord resumptionRecord = null;
        if (maybeState instanceof ClassDefinitionResumptionRecord) {
            this.resetState(frame, stateSlot);
            resumptionRecord = (ClassDefinitionResumptionRecord)maybeState;
        }
        return this.executeWithName(frame, null, resumptionRecord, stateSlot);
    }

    @Override
    public Object executeWithName(VirtualFrame frame, Object className) {
        return this.executeWithName(frame, className, null, -1);
    }

    private JSFunctionObject executeWithName(VirtualFrame frame, Object className, ClassDefinitionResumptionRecord resumptionRecord, int stateSlot) {
        int startIndex;
        int staticElementIndex;
        int instanceFieldIndex;
        Object[][] staticElements;
        Object[][] instanceFields;
        JSFunctionObject constructor;
        JSDynamicObject proto;
        JSRealm realm = this.getRealm();
        if (resumptionRecord == null) {
            Object protoParent = realm.getObjectPrototype();
            Object constructorParent = realm.getFunctionPrototype();
            if (this.classHeritageNode != null) {
                Object superclass = this.classHeritageNode.execute(frame);
                if (superclass == Null.instance) {
                    protoParent = Null.instance;
                } else {
                    if (!this.isConstructorNode.executeBoolean(superclass)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("not a constructor", (Node)this);
                    }
                    if (JSRuntime.isGenerator(superclass)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("class cannot extend a generator function", (Node)this);
                    }
                    protoParent = this.getPrototypeNode.getValue(superclass);
                    if (protoParent != Null.instance && !JSRuntime.isObject(protoParent)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("protoParent is neither Object nor Null", (Node)this);
                    }
                    constructorParent = superclass;
                }
            }
            assert (protoParent == Null.instance || JSRuntime.isObject(protoParent));
            proto = this.createPrototypeNode.execute((JSDynamicObject)((Object)protoParent));
            constructor = this.defineConstructorMethodNode.execute(frame, proto, (JSDynamicObject)((Object)constructorParent));
            JSFunction.setClassPrototype(constructor, (Object)proto);
            if (this.setFunctionName != null && className != null) {
                this.setFunctionName.execute((Object)constructor, className);
            }
            this.setConstructorNode.executeVoid((Object)proto, (Object)constructor);
            instanceFields = this.instanceFieldCount == 0 ? null : new Object[this.instanceFieldCount][];
            staticElements = this.staticElementCount == 0 ? null : new Object[this.staticElementCount][];
            instanceFieldIndex = 0;
            staticElementIndex = 0;
            startIndex = 0;
        } else {
            proto = resumptionRecord.proto;
            constructor = resumptionRecord.constructor;
            instanceFields = resumptionRecord.instanceFields;
            staticElements = resumptionRecord.staticElements;
            instanceFieldIndex = resumptionRecord.instanceFieldIndex;
            staticElementIndex = resumptionRecord.staticElementIndex;
            startIndex = resumptionRecord.index;
        }
        this.initializeMembers(frame, proto, constructor, instanceFields, staticElements, startIndex, instanceFieldIndex, staticElementIndex, stateSlot, realm);
        if (this.writeClassBindingNode != null) {
            this.writeClassBindingNode.executeWrite(frame, (Object)constructor);
        }
        if (this.setFieldsNode != null) {
            this.setFieldsNode.setValue((Object)constructor, instanceFields);
        }
        if (this.setPrivateBrandNode != null) {
            HiddenKey privateBrand = new HiddenKey("Brand");
            this.setPrivateBrandNode.setValue((Object)constructor, privateBrand);
        }
        if (this.writeInternalConstructorBrand != null) {
            this.writeInternalConstructorBrand.executeWrite(frame, (Object)constructor);
        }
        if (this.staticElementCount != 0) {
            InitializeInstanceElementsNode initializeStaticElements = this.staticElementsNode;
            if (initializeStaticElements == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.staticElementsNode = initializeStaticElements = (InitializeInstanceElementsNode)this.insert(InitializeInstanceElementsNode.create(this.context));
            }
            initializeStaticElements.executeStaticElements((Object)constructor, staticElements);
        }
        return constructor;
    }

    @ExplodeLoop
    private void initializeMembers(VirtualFrame frame, JSDynamicObject proto, JSFunctionObject constructor, Object[][] instanceFields, Object[][] staticElements, int startIndex, int instanceFieldIdx, int staticElementIdx, int stateSlot, JSRealm realm) {
        int i;
        int instanceFieldIndex = instanceFieldIdx;
        int staticElementIndex = staticElementIdx;
        try {
            for (i = 0; i < this.memberNodes.length; ++i) {
                if (i < startIndex) continue;
                ObjectLiteralNode.ObjectLiteralMemberNode memberNode = this.memberNodes[i];
                JSDynamicObject homeObject = memberNode.isStatic() ? constructor : proto;
                memberNode.executeVoid(frame, homeObject, realm);
                if (!memberNode.isFieldOrStaticBlock()) continue;
                Object key = memberNode.evaluateKey(frame);
                Object value = memberNode.evaluateValue(frame, homeObject, realm);
                Object[] field = new Object[]{key, value, memberNode.isAnonymousFunctionDefinition()};
                if (memberNode.isStatic()) {
                    staticElements[staticElementIndex++] = field;
                    continue;
                }
                if (instanceFields != null) {
                    instanceFields[instanceFieldIndex++] = field;
                    continue;
                }
                throw Errors.shouldNotReachHere();
            }
        }
        catch (YieldException e) {
            this.setState(frame, stateSlot, new ClassDefinitionResumptionRecord(proto, constructor, instanceFields, staticElements, instanceFieldIndex, staticElementIndex, i));
            throw e;
        }
        assert (instanceFieldIndex == this.instanceFieldCount && staticElementIndex == this.staticElementCount);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == JSDynamicObject.class;
    }

    @Override
    public TruffleString getFunctionName() {
        return this.hasName ? ((FunctionNameHolder)((Object)this.constructorFunctionNode)).getFunctionName() : Strings.EMPTY_STRING;
    }

    @Override
    public void setFunctionName(TruffleString name) {
        ((FunctionNameHolder)((Object)this.constructorFunctionNode)).setFunctionName(name);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new ClassDefinitionNode(this.context, (JSFunctionExpressionNode)ClassDefinitionNode.cloneUninitialized(this.constructorFunctionNode, materializedTags), ClassDefinitionNode.cloneUninitialized(this.classHeritageNode, materializedTags), ObjectLiteralNode.ObjectLiteralMemberNode.cloneUninitialized(this.memberNodes, materializedTags), ClassDefinitionNode.cloneUninitialized(this.writeClassBindingNode, materializedTags), ClassDefinitionNode.cloneUninitialized(this.writeInternalConstructorBrand, materializedTags), this.hasName, this.instanceFieldCount, this.staticElementCount, this.setPrivateBrandNode != null, this.defineConstructorMethodNode.getBlockScopeSlot());
    }

    static class ClassDefinitionResumptionRecord {
        final JSDynamicObject proto;
        final JSFunctionObject constructor;
        final Object[][] instanceFields;
        final Object[][] staticElements;
        final int instanceFieldIndex;
        final int staticElementIndex;
        final int index;

        ClassDefinitionResumptionRecord(JSDynamicObject proto, JSFunctionObject constructor, Object[][] instanceFields, Object[][] staticElements, int instanceFieldIndex, int staticElementIndex, int index) {
            this.proto = proto;
            this.constructor = constructor;
            this.instanceFields = instanceFields;
            this.staticElements = staticElements;
            this.instanceFieldIndex = instanceFieldIndex;
            this.staticElementIndex = staticElementIndex;
            this.index = index;
        }
    }
}

