/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.probe;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridProbeCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.PROBE);

    public GridProbeCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        assert (req != null);
        assert (SUPPORTED_COMMANDS.contains((Object)req.command()));
        switch (req.command()) {
            case PROBE: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("probe command handler invoked.");
                }
                return new GridFinishedFuture<GridRestResponse>(IgnitionEx.hasKernalStarted(this.ctx.igniteInstanceName()) ? new GridRestResponse("grid has started") : new GridRestResponse(503, "grid has not started"));
            }
        }
        return new GridFinishedFuture<GridRestResponse>();
    }
}

