/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.ignite3.internal.raft.Command;
import org.apache.ignite3.internal.raft.GroupOverloadedException;
import org.apache.ignite3.internal.raft.service.RaftCommandRunner;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.exception.ReplicationException;
import org.apache.ignite3.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite3.internal.util.ExceptionUtils;

public class ReplicationRaftCommandApplicator {
    private final RaftCommandRunner raftCommandRunner;
    private final ReplicationGroupId replicationGroupId;

    public ReplicationRaftCommandApplicator(RaftCommandRunner raftCommandRunner, ReplicationGroupId replicationGroupId) {
        this.raftCommandRunner = raftCommandRunner;
        this.replicationGroupId = replicationGroupId;
    }

    public CompletableFuture<Object> applyCommandWithExceptionHandling(Command command) {
        CompletableFuture<Object> resultFuture = new CompletableFuture<Object>();
        this.applyCommandWithExceptionHandling(command, resultFuture);
        return resultFuture.exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                throw new ReplicationTimeoutException(this.replicationGroupId);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ReplicationException(this.replicationGroupId, (Throwable)throwable);
        });
    }

    private void applyCommandWithExceptionHandling(Command command, CompletableFuture<Object> resultFuture) {
        this.raftCommandRunner.run(command).whenComplete((res, ex) -> {
            if (ex != null) {
                Throwable cause = ExceptionUtils.unwrapRootCause(ex);
                if (cause instanceof GroupOverloadedException) {
                    this.applyCommandWithExceptionHandling(command, resultFuture);
                } else {
                    resultFuture.completeExceptionally((Throwable)ex);
                }
            } else {
                resultFuture.complete(res);
            }
        });
    }

    public CompletableFuture<?> applyCommand(Command command) {
        return this.raftCommandRunner.run(command);
    }
}

