/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.deployunit.DefaultNodeCallback;
import org.apache.ignite.internal.deployunit.DeployMessagingService;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.DeploymentUnit;
import org.apache.ignite.internal.deployunit.DeploymentUnitAccessor;
import org.apache.ignite.internal.deployunit.DeploymentUnitAccessorImpl;
import org.apache.ignite.internal.deployunit.DeploymentUnitAcquiredWaiter;
import org.apache.ignite.internal.deployunit.DownloadTracker;
import org.apache.ignite.internal.deployunit.FileDeployerService;
import org.apache.ignite.internal.deployunit.IgniteDeployment;
import org.apache.ignite.internal.deployunit.NodesToDeploy;
import org.apache.ignite.internal.deployunit.StaticUnitDeployer;
import org.apache.ignite.internal.deployunit.UnitDownloader;
import org.apache.ignite.internal.deployunit.UnitStatus;
import org.apache.ignite.internal.deployunit.UnitStatuses;
import org.apache.ignite.internal.deployunit.configuration.DeploymentConfiguration;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitAlreadyExistsException;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitNotFoundException;
import org.apache.ignite.internal.deployunit.metastore.ClusterEventCallback;
import org.apache.ignite.internal.deployunit.metastore.ClusterEventCallbackImpl;
import org.apache.ignite.internal.deployunit.metastore.ClusterStatusWatchListener;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitFailover;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.NodeEventCallback;
import org.apache.ignite.internal.deployunit.metastore.NodeStatusWatchListener;
import org.apache.ignite.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.deployunit.tempstorage.TempStorageProvider;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class DeploymentManagerImpl
implements IgniteDeployment {
    private static final IgniteLogger LOG = Loggers.forClass(DeploymentManagerImpl.class);
    private static final Duration UNDEPLOYER_DELAY = Duration.ofSeconds(5L);
    private final Path workDir;
    private final DeploymentConfiguration configuration;
    private final ClusterManagementGroupManager cmgManager;
    private final DeployMessagingService messaging;
    private final FileDeployerService deployer;
    private final DeploymentUnitStore deploymentUnitStore;
    private final DownloadTracker tracker;
    private final DeploymentUnitFailover failover;
    private final DeploymentUnitAccessor deploymentUnitAccessor;
    private final DeploymentUnitAcquiredWaiter undeployer;
    private final String nodeName;
    private final NodeEventCallback nodeStatusCallback;
    private final NodeStatusWatchListener nodeStatusWatchListener;
    private final ClusterEventCallback clusterEventCallback;
    private final ClusterStatusWatchListener clusterStatusWatchListener;
    private final UnitDownloader unitDownloader;

    public DeploymentManagerImpl(ClusterService clusterService, DeploymentUnitStore deploymentUnitStore, LogicalTopologyService logicalTopology, Path workDir, DeploymentConfiguration configuration, ClusterManagementGroupManager cmgManager, String nodeName, Consumer<Path> onPathRemoving) {
        this.deploymentUnitStore = deploymentUnitStore;
        this.configuration = configuration;
        this.cmgManager = cmgManager;
        this.workDir = workDir;
        this.nodeName = nodeName;
        this.tracker = new DownloadTracker();
        this.deployer = new FileDeployerService(nodeName);
        this.deploymentUnitAccessor = new DeploymentUnitAccessorImpl(this.deployer);
        this.undeployer = new DeploymentUnitAcquiredWaiter(nodeName, this.deploymentUnitAccessor, unit -> {
            onPathRemoving.accept(this.deployer.unitPath(unit.name(), unit.version(), false));
            deploymentUnitStore.updateNodeStatus(nodeName, unit.name(), unit.version(), DeploymentStatus.REMOVING);
        });
        this.messaging = new DeployMessagingService(clusterService, cmgManager, this.deployer, this.tracker);
        this.unitDownloader = new UnitDownloader(deploymentUnitStore, nodeName, this.deployer, this.tracker, this.messaging);
        this.nodeStatusCallback = new DefaultNodeCallback(deploymentUnitStore, this.undeployer, this.unitDownloader, cmgManager);
        this.nodeStatusWatchListener = new NodeStatusWatchListener(deploymentUnitStore, nodeName, this.nodeStatusCallback);
        this.clusterEventCallback = new ClusterEventCallbackImpl(deploymentUnitStore, this.deployer, cmgManager, nodeName);
        this.clusterStatusWatchListener = new ClusterStatusWatchListener(this.clusterEventCallback);
        this.failover = new DeploymentUnitFailover(logicalTopology, deploymentUnitStore, this.deployer, nodeName);
    }

    @Override
    public CompletableFuture<Boolean> deployAsync(String id, Version version, boolean force, DeploymentUnit deploymentUnit, NodesToDeploy deployedNodes) {
        DeploymentManagerImpl.checkId(id);
        Objects.requireNonNull(version);
        Objects.requireNonNull(deploymentUnit);
        LOG.info("Deploying {}:{} on {}", new Object[]{id, version, deployedNodes});
        return deployedNodes.extractNodes(this.cmgManager).thenCompose(nodesToDeploy -> this.doDeploy(id, version, force, deploymentUnit, (Set<String>)nodesToDeploy));
    }

    private CompletableFuture<Boolean> doDeploy(String id, Version version, boolean force, DeploymentUnit deploymentUnit, Set<String> nodesToDeploy) {
        return this.deploymentUnitStore.createClusterStatus(id, version, nodesToDeploy).thenCompose(clusterStatus -> {
            if (clusterStatus != null) {
                return this.doDeploy((UnitClusterStatus)clusterStatus, deploymentUnit, nodesToDeploy);
            }
            if (force) {
                return this.undeployAsync(id, version).thenCompose(u -> this.doDeploy(id, version, false, deploymentUnit, nodesToDeploy));
            }
            LOG.warn("Failed to deploy meta of unit " + id + ":" + String.valueOf(version) + " to metastore. Already exists.", new Object[0]);
            return CompletableFuture.failedFuture((Throwable)((Object)new DeploymentUnitAlreadyExistsException(id, "Unit " + id + ":" + String.valueOf(version) + " already exists")));
        });
    }

    private CompletableFuture<Boolean> doDeploy(UnitClusterStatus clusterStatus, DeploymentUnit deploymentUnit, Set<String> nodesToDeploy) {
        return this.deployToLocalNode(clusterStatus, deploymentUnit).thenApply(completed -> {
            if (completed.booleanValue()) {
                nodesToDeploy.forEach(node -> {
                    if (!node.equals(this.nodeName)) {
                        this.deploymentUnitStore.createNodeStatus((String)node, clusterStatus.id(), clusterStatus.version(), clusterStatus.opId(), DeploymentStatus.UPLOADING);
                    }
                });
            }
            return completed;
        });
    }

    private CompletableFuture<Boolean> deployToLocalNode(UnitClusterStatus clusterStatus, DeploymentUnit deploymentUnit) {
        return this.deployer.deploy(clusterStatus.id(), clusterStatus.version(), deploymentUnit).thenCompose(deployed -> {
            if (deployed.booleanValue()) {
                return this.deploymentUnitStore.createNodeStatus(this.nodeName, clusterStatus.id(), clusterStatus.version(), clusterStatus.opId(), DeploymentStatus.DEPLOYED);
            }
            return CompletableFutures.falseCompletedFuture();
        });
    }

    @Override
    public CompletableFuture<Boolean> undeployAsync(String id, Version version) {
        DeploymentManagerImpl.checkId(id);
        Objects.requireNonNull(version);
        LOG.info("Undeploying {}:{}", new Object[]{id, version});
        return ((CompletableFuture)this.messaging.stopInProgressDeploy(id, version).thenCompose(v -> this.deploymentUnitStore.updateClusterStatus(id, version, DeploymentStatus.OBSOLETE))).thenCompose(success -> {
            if (success.booleanValue()) {
                return this.cmgManager.logicalTopology().thenCompose(logicalTopology -> {
                    Set logicalNodes = logicalTopology.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
                    return ((CompletableFuture)this.deploymentUnitStore.getAllNodes(id, version).thenCompose(nodes -> CompletableFuture.allOf((CompletableFuture[])nodes.stream().filter(logicalNodes::contains).map(node -> this.deploymentUnitStore.updateNodeStatus((String)node, id, version, DeploymentStatus.OBSOLETE)).toArray(CompletableFuture[]::new)))).thenApply(v -> true);
                });
            }
            return CompletableFuture.failedFuture((Throwable)((Object)new DeploymentUnitNotFoundException(id, version)));
        });
    }

    @Override
    public CompletableFuture<List<UnitStatuses>> clusterStatusesAsync() {
        return this.deploymentUnitStore.getClusterStatuses().thenApply(DeploymentManagerImpl::fromUnitStatuses);
    }

    @Override
    public CompletableFuture<UnitStatuses> clusterStatusesAsync(String id) {
        DeploymentManagerImpl.checkId(id);
        return this.deploymentUnitStore.getClusterStatuses(id).thenApply(statuses -> DeploymentManagerImpl.fromUnitStatuses(id, statuses));
    }

    @Override
    public CompletableFuture<DeploymentStatus> clusterStatusAsync(String id, Version version) {
        DeploymentManagerImpl.checkId(id);
        Objects.requireNonNull(version);
        return this.deploymentUnitStore.getClusterStatus(id, version).thenApply(DeploymentManagerImpl::extractDeploymentStatus);
    }

    @Override
    public CompletableFuture<List<Version>> versionsAsync(String id) {
        DeploymentManagerImpl.checkId(id);
        return this.deploymentUnitStore.getClusterStatuses(id).thenApply(statuses -> statuses.stream().map(UnitStatus::version).sorted().collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<List<UnitStatuses>> nodeStatusesAsync() {
        return this.deploymentUnitStore.getNodeStatuses(this.nodeName).thenApply(DeploymentManagerImpl::fromUnitStatuses);
    }

    @Override
    public CompletableFuture<UnitStatuses> nodeStatusesAsync(String id) {
        DeploymentManagerImpl.checkId(id);
        return this.deploymentUnitStore.getNodeStatuses(this.nodeName, id).thenApply(statuses -> DeploymentManagerImpl.fromUnitStatuses(id, statuses));
    }

    @Override
    public CompletableFuture<DeploymentStatus> nodeStatusAsync(String id, Version version) {
        DeploymentManagerImpl.checkId(id);
        Objects.requireNonNull(version);
        return this.deploymentUnitStore.getNodeStatus(this.nodeName, id, version).thenApply(DeploymentManagerImpl::extractDeploymentStatus);
    }

    @Override
    public CompletableFuture<Boolean> onDemandDeploy(String id, Version version) {
        return this.deploymentUnitStore.getAllNodeStatuses(id, version).thenCompose(statuses -> {
            if (statuses.isEmpty()) {
                return CompletableFutures.falseCompletedFuture();
            }
            Optional<UnitNodeStatus> nodeStatus = statuses.stream().filter(status -> status.nodeId().equals(this.nodeName)).findFirst();
            if (nodeStatus.isPresent()) {
                switch (nodeStatus.get().status()) {
                    case UPLOADING: {
                        LOG.debug("Status is UPLOADING, downloading the unit", new Object[0]);
                        return this.unitDownloader.downloadUnit((Collection<UnitNodeStatus>)statuses, id, version);
                    }
                    case DEPLOYED: {
                        LOG.debug("Status is DEPLOYED", new Object[0]);
                        return CompletableFutures.trueCompletedFuture();
                    }
                }
                LOG.debug("Invalid status {}", new Object[]{nodeStatus.get().status()});
                return CompletableFutures.falseCompletedFuture();
            }
            return this.deploymentUnitStore.getClusterStatus(id, version).thenCompose(clusterStatus -> this.deploymentUnitStore.createNodeStatus(this.nodeName, id, version, clusterStatus.opId(), DeploymentStatus.UPLOADING).thenCompose(created -> {
                LOG.debug("Status {}, downloading the unit", new Object[]{created != false ? "created" : "not created"});
                return this.unitDownloader.downloadUnit((Collection<UnitNodeStatus>)statuses, id, version);
            }));
        });
    }

    @Override
    public CompletableFuture<Version> detectLatestDeployedVersion(String id) {
        return this.clusterStatusesAsync(id).thenApply(statuses -> {
            if (statuses == null) {
                throw new DeploymentUnitNotFoundException(id, Version.LATEST);
            }
            return statuses.versionStatuses().stream().filter(e -> e.getStatus() == DeploymentStatus.DEPLOYED).reduce((first, second) -> second).orElseThrow(() -> new DeploymentUnitNotFoundException(id, Version.LATEST)).getVersion();
        });
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        Path deploymentUnitFolder = this.workDir.resolve((String)this.configuration.location().value());
        Path deploymentUnitTmp = this.workDir.resolve((String)this.configuration.tempLocation().value());
        this.deployer.initUnitsFolder(deploymentUnitFolder, deploymentUnitTmp);
        this.deploymentUnitStore.registerNodeStatusListener(this.nodeStatusWatchListener);
        this.deploymentUnitStore.registerClusterStatusListener(this.clusterStatusWatchListener);
        this.messaging.subscribe();
        this.failover.registerTopologyChangeCallback(this.nodeStatusCallback, this.clusterEventCallback);
        this.undeployer.start(UNDEPLOYER_DELAY.getSeconds(), TimeUnit.SECONDS);
        return new StaticUnitDeployer(this.deploymentUnitStore, this.nodeName, deploymentUnitFolder).searchAndDeployStaticUnits();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.deployer.stop();
        this.nodeStatusWatchListener.stop();
        this.tracker.cancelAll();
        this.deploymentUnitStore.unregisterNodeStatusListener(this.nodeStatusWatchListener);
        this.deploymentUnitStore.unregisterClusterStatusListener(this.clusterStatusWatchListener);
        this.undeployer.stop();
        return CompletableFutures.nullCompletedFuture();
    }

    private static void checkId(String id) {
        Objects.requireNonNull(id);
        if (id.isBlank()) {
            throw new IllegalArgumentException("Id is blank");
        }
    }

    private static List<UnitStatuses> fromUnitStatuses(List<? extends UnitStatus> statuses) {
        HashMap<String, UnitStatuses.UnitStatusesBuilder> map = new HashMap<String, UnitStatuses.UnitStatusesBuilder>();
        for (UnitStatus unitStatus : statuses) {
            map.computeIfAbsent(unitStatus.id(), UnitStatuses::builder).append(unitStatus.version(), unitStatus.status()).build();
        }
        return map.values().stream().map(UnitStatuses.UnitStatusesBuilder::build).collect(Collectors.toList());
    }

    @Nullable
    private static UnitStatuses fromUnitStatuses(String id, List<? extends UnitStatus> statuses) {
        if (statuses.isEmpty()) {
            return null;
        }
        UnitStatuses.UnitStatusesBuilder builder = UnitStatuses.builder(id);
        for (UnitStatus unitStatus : statuses) {
            builder.append(unitStatus.version(), unitStatus.status());
        }
        return builder.build();
    }

    @Nullable
    private static DeploymentStatus extractDeploymentStatus(UnitStatus status) {
        return status != null ? status.status() : null;
    }

    public DeploymentUnitAccessor deploymentUnitAccessor() {
        return this.deploymentUnitAccessor;
    }

    public TempStorageProvider tempStorageProvider() {
        return this.deployer.tempStorageProvider();
    }
}

