/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.index.ChangeIndexStatusTaskScheduler;
import org.apache.ignite.internal.index.IndexManagementUtils;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

class ChangeIndexStatusTaskController
implements ManuallyCloseable {
    private final CatalogService catalogService;
    private final PlacementDriver placementDriver;
    private final ClusterService clusterService;
    private final ChangeIndexStatusTaskScheduler changeIndexStatusTaskScheduler;
    private final Set<Integer> localNodeIsPrimaryReplicaForTableIds = ConcurrentHashMap.newKeySet();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();

    ChangeIndexStatusTaskController(CatalogManager catalogManager, PlacementDriver placementDriver, ClusterService clusterService, ChangeIndexStatusTaskScheduler changeIndexStatusTaskScheduler) {
        this.catalogService = catalogManager;
        this.placementDriver = placementDriver;
        this.clusterService = clusterService;
        this.changeIndexStatusTaskScheduler = changeIndexStatusTaskScheduler;
    }

    public void start() {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, this::addListeners);
    }

    public void close() throws Exception {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.changeIndexStatusTaskScheduler.close();
    }

    private void addListeners() {
        this.catalogService.listen((Event)CatalogEvent.INDEX_CREATE, EventListener.fromConsumer(this::onIndexCreated));
        this.catalogService.listen((Event)CatalogEvent.INDEX_STOPPING, EventListener.fromConsumer(this::onIndexDropped));
        this.catalogService.listen((Event)CatalogEvent.INDEX_REMOVED, EventListener.fromConsumer(this::onIndexRemoved));
        this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, EventListener.fromConsumer(this::onPrimaryReplicaElected));
    }

    private void onIndexCreated(CreateIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            CatalogIndexDescriptor indexDescriptor = parameters.indexDescriptor();
            if (this.localNodeIsPrimaryReplicaForTableIds.contains(indexDescriptor.tableId())) {
                this.changeIndexStatusTaskScheduler.scheduleStartBuildingTask(parameters.indexDescriptor());
            }
        });
    }

    private void onIndexDropped(StoppingIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            CatalogIndexDescriptor indexDescriptor = this.catalogService.index(parameters.indexId(), parameters.catalogVersion());
            assert (indexDescriptor != null) : parameters.indexId();
            if (this.localNodeIsPrimaryReplicaForTableIds.contains(indexDescriptor.tableId())) {
                this.changeIndexStatusTaskScheduler.scheduleRemoveIndexTask(indexDescriptor);
            }
        });
    }

    private void onIndexRemoved(RemoveIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.changeIndexStatusTaskScheduler.stopStartBuildingTask(parameters.indexId()));
    }

    private void onPrimaryReplicaElected(PrimaryReplicaEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            TablePartitionId primaryReplicaId = (TablePartitionId)parameters.groupId();
            if (primaryReplicaId.partitionId() != 0) {
                return;
            }
            int tableId = primaryReplicaId.tableId();
            if (IndexManagementUtils.isLocalNode(this.clusterService, parameters.leaseholderId())) {
                if (this.localNodeIsPrimaryReplicaForTableIds.add(tableId)) {
                    this.scheduleTasksOnPrimaryReplicaElectedBusy(tableId);
                }
            } else if (this.localNodeIsPrimaryReplicaForTableIds.remove(tableId)) {
                this.changeIndexStatusTaskScheduler.stopTasksForTable(tableId);
            }
        });
    }

    private void scheduleTasksOnPrimaryReplicaElectedBusy(int tableId) {
        int catalogVersion = this.catalogService.latestCatalogVersion();
        for (CatalogIndexDescriptor indexDescriptor : this.catalogService.indexes(catalogVersion, tableId)) {
            switch (indexDescriptor.status()) {
                case REGISTERED: {
                    this.changeIndexStatusTaskScheduler.scheduleStartBuildingTask(indexDescriptor);
                    break;
                }
                case STOPPING: {
                    this.changeIndexStatusTaskScheduler.scheduleRemoveIndexTask(indexDescriptor);
                    break;
                }
            }
        }
    }
}

