/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.IgniteTables;

public class ClientTableGetRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteTables tables) {
        String tableName = in.unpackString();
        return tables.tableAsync(tableName).thenAccept(table -> {
            if (table == null) {
                out.packNil();
            } else {
                out.packInt(((TableViewInternal)table).tableId());
                out.packString(ClientTableGetRequest.quoteTableNameIfNotAllUpper(table.name()));
            }
        });
    }

    private static String quoteTableNameIfNotAllUpper(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isDigit(ch) || ch == '_' || Character.isUpperCase(ch)) continue;
            return IgniteNameUtils.quote((String)name);
        }
        return name;
    }
}

