/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.engine;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.ThreadAssertingMvPartitionStorage;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.index.ThreadAssertingHashIndexStorage;
import org.apache.ignite.internal.storage.index.ThreadAssertingSortedIndexStorage;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingMvTableStorage
implements MvTableStorage,
Wrapper {
    private final MvTableStorage tableStorage;

    public ThreadAssertingMvTableStorage(MvTableStorage tableStorage) {
        this.tableStorage = tableStorage;
    }

    public void close() throws Exception {
        this.tableStorage.close();
    }

    @Override
    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.createMvPartition(partitionId).thenApply(ThreadAssertingMvPartitionStorage::new);
    }

    @Override
    @Nullable
    public MvPartitionStorage getMvPartition(int partitionId) {
        MvPartitionStorage partition = this.tableStorage.getMvPartition(partitionId);
        return partition == null ? null : new ThreadAssertingMvPartitionStorage(partition);
    }

    @Override
    public CompletableFuture<Void> destroyPartition(int partitionId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.destroyPartition(partitionId);
    }

    @Override
    public SortedIndexStorage getOrCreateSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        ThreadAssertions.assertThreadAllowsToWrite();
        SortedIndexStorage indexStorage = this.tableStorage.getOrCreateSortedIndex(partitionId, indexDescriptor);
        return new ThreadAssertingSortedIndexStorage(indexStorage);
    }

    @Override
    public HashIndexStorage getOrCreateHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        ThreadAssertions.assertThreadAllowsToWrite();
        HashIndexStorage indexStorage = this.tableStorage.getOrCreateHashIndex(partitionId, indexDescriptor);
        return new ThreadAssertingHashIndexStorage(indexStorage);
    }

    @Override
    public CompletableFuture<Void> destroyIndex(int indexId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.destroyIndex(indexId);
    }

    @Override
    public boolean isVolatile() {
        return this.tableStorage.isVolatile();
    }

    @Override
    public CompletableFuture<Void> destroy() {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.destroy();
    }

    @Override
    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.startRebalancePartition(partitionId);
    }

    @Override
    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.abortRebalancePartition(partitionId);
    }

    @Override
    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.finishRebalancePartition(partitionId, partitionMeta);
    }

    @Override
    public CompletableFuture<Void> clearPartition(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.tableStorage.clearPartition(partitionId);
    }

    @Override
    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return this.tableStorage.getIndex(partitionId, indexId);
    }

    @Override
    public StorageTableDescriptor getTableDescriptor() {
        return this.tableStorage.getTableDescriptor();
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.tableStorage);
    }
}

