/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.sql.configuration.distributed.SqlDistributedConfiguration;
import org.apache.ignite.internal.sql.configuration.local.SqlLocalConfiguration;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InflightTransactionTracker;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.QueryPrefetchCallback;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlQueriesViewProvider;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite.internal.sql.engine.api.kill.OperationKillHandler;
import org.apache.ignite.internal.sql.engine.exec.ExchangeServiceImpl;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTableRegistryImpl;
import org.apache.ignite.internal.sql.engine.exec.ExecutionDependencyResolverImpl;
import org.apache.ignite.internal.sql.engine.exec.ExecutionServiceImpl;
import org.apache.ignite.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistryImpl;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutorImpl;
import org.apache.ignite.internal.sql.engine.exec.SqlRowHandler;
import org.apache.ignite.internal.sql.engine.exec.TransactionTracker;
import org.apache.ignite.internal.sql.engine.exec.ddl.DdlCommandHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.func.TableFunctionRegistryImpl;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryIdGenerator;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite.internal.sql.engine.exec.fsm.ValidationHelper;
import org.apache.ignite.internal.sql.engine.exec.kill.KillCommandHandler;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionDistributionProviderImpl;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingServiceImpl;
import org.apache.ignite.internal.sql.engine.message.MessageServiceImpl;
import org.apache.ignite.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite.internal.sql.engine.prepare.PrepareServiceImpl;
import org.apache.ignite.internal.sql.engine.prepare.QueryMetadata;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPrunerImpl;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesHelper;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManagerImpl;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.sql.ParserServiceImpl;
import org.apache.ignite.internal.sql.engine.statistic.SqlStatisticManager;
import org.apache.ignite.internal.sql.engine.statistic.SqlStatisticManagerImpl;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContextImpl;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite.internal.sql.engine.util.cache.CaffeineCacheFactory;
import org.apache.ignite.internal.sql.metrics.SqlClientMetricSource;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewManager;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlQueryProcessor
implements QueryProcessor,
SystemViewProvider {
    public static final ZoneId DEFAULT_TIME_ZONE_ID = ZoneId.of("UTC");
    private static final int PARSED_RESULT_CACHE_SIZE = 10000;
    private static final int TABLE_CACHE_SIZE = 1024;
    private static final int COMPILED_EXPRESSIONS_CACHE_SIZE = 1024;
    private static final int SCHEMA_CACHE_SIZE = 128;
    public static final SqlProperties DEFAULT_PROPERTIES = SqlPropertiesHelper.newBuilder().set(QueryProperty.DEFAULT_SCHEMA, "PUBLIC").set(QueryProperty.ALLOWED_QUERY_TYPES, SqlQueryType.ALL).set(QueryProperty.TIME_ZONE_ID, DEFAULT_TIME_ZONE_ID).set(QueryProperty.QUERY_TIMEOUT, 0L).build();
    private static final CacheFactory CACHE_FACTORY = CaffeineCacheFactory.INSTANCE;
    private static final long EXECUTION_SERVICE_SHUTDOWN_TIMEOUT = 60000L;
    private final SqlQueriesViewProvider queriesViewProvider = new SqlQueriesViewProvider();
    private final List<LifecycleAware> services = new ArrayList<LifecycleAware>();
    private final ClusterService clusterSrvc;
    private final LogicalTopologyService logicalTopologyService;
    private final TableManager tableManager;
    private final SchemaManager schemaManager;
    private final DataStorageManager dataStorageManager;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ReplicaService replicaService;
    private final SqlSchemaManager sqlSchemaManager;
    private final SqlStatisticManager sqlStatisticManager;
    private final FailureManager failureManager;
    private final SystemViewManager systemViewManager;
    private final KillCommandHandler killCommandHandler;
    private volatile QueryExecutor queryExecutor;
    private volatile QueryTaskExecutor taskExecutor;
    private volatile PrepareService prepareSvc;
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final CatalogManager catalogManager;
    private final MetricManager metricManager;
    private final PlacementDriver placementDriver;
    private final SqlDistributedConfiguration clusterCfg;
    private final SqlLocalConfiguration nodeCfg;
    private final TxManager txManager;
    private final TransactionTracker txTracker;
    private final ScheduledExecutorService commonScheduler;
    private final EventLog eventLog;

    public SqlQueryProcessor(ClusterService clusterSrvc, LogicalTopologyService logicalTopologyService, TableManager tableManager, SchemaManager schemaManager, DataStorageManager dataStorageManager, ReplicaService replicaService, ClockService clockService, SchemaSyncService schemaSyncService, CatalogManager catalogManager, MetricManager metricManager, SystemViewManager systemViewManager, FailureManager failureManager, PlacementDriver placementDriver, SqlDistributedConfiguration clusterCfg, SqlLocalConfiguration nodeCfg, TransactionInflights transactionInflights, TxManager txManager, LowWatermark lowWaterMark, ScheduledExecutorService commonScheduler, KillCommandHandler killCommandHandler, EventLog eventLog) {
        this.clusterSrvc = clusterSrvc;
        this.logicalTopologyService = logicalTopologyService;
        this.tableManager = tableManager;
        this.schemaManager = schemaManager;
        this.dataStorageManager = dataStorageManager;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.catalogManager = catalogManager;
        this.metricManager = metricManager;
        this.systemViewManager = systemViewManager;
        this.failureManager = failureManager;
        this.placementDriver = placementDriver;
        this.clusterCfg = clusterCfg;
        this.nodeCfg = nodeCfg;
        this.txTracker = new InflightTransactionTracker(transactionInflights);
        this.txManager = txManager;
        this.commonScheduler = commonScheduler;
        this.killCommandHandler = killCommandHandler;
        this.eventLog = eventLog;
        this.sqlStatisticManager = new SqlStatisticManagerImpl(tableManager, (CatalogService)catalogManager, lowWaterMark);
        this.sqlSchemaManager = new SqlSchemaManagerImpl(catalogManager, this.sqlStatisticManager, CACHE_FACTORY, 128);
    }

    public synchronized CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        String nodeName = this.clusterSrvc.topologyService().localMember().name();
        this.taskExecutor = this.registerService(new QueryTaskExecutorImpl(nodeName, (Integer)this.nodeCfg.execution().threadCount().value(), this.failureManager));
        MailboxRegistryImpl mailboxRegistry = this.registerService(new MailboxRegistryImpl());
        SqlClientMetricSource sqlClientMetricSource = new SqlClientMetricSource(this::openedCursors);
        this.metricManager.registerSource((MetricSource)sqlClientMetricSource);
        this.metricManager.enable((MetricSource)sqlClientMetricSource);
        PrepareServiceImpl prepareSvc = this.registerService(PrepareServiceImpl.create(nodeName, CACHE_FACTORY, this.dataStorageManager, this.metricManager, this.clusterCfg, this.nodeCfg, this.sqlSchemaManager));
        MessageServiceImpl msgSrvc = this.registerService(new MessageServiceImpl(nodeName, this.clusterSrvc.messagingService(), this.taskExecutor, this.busyLock, this.clockService));
        ExchangeServiceImpl exchangeService = this.registerService(new ExchangeServiceImpl(mailboxRegistry, msgSrvc, this.clockService));
        this.prepareSvc = prepareSvc;
        DdlCommandHandler ddlCommandHandler = this.registerService(new DdlCommandHandler(this.catalogManager, this.clockService));
        ExecutableTableRegistryImpl executableTableRegistry = new ExecutableTableRegistryImpl(this.tableManager, this.schemaManager, this.sqlSchemaManager, this.replicaService, this.clockService, 1024, CACHE_FACTORY);
        TableFunctionRegistryImpl tableFunctionRegistry = new TableFunctionRegistryImpl();
        ExecutionDependencyResolverImpl dependencyResolver = new ExecutionDependencyResolverImpl(executableTableRegistry, view -> () -> this.systemViewManager.scanView(view.name()));
        PartitionPrunerImpl partitionPruner = new PartitionPrunerImpl();
        MappingServiceImpl mappingService = new MappingServiceImpl(nodeName, this.clockService, CACHE_FACTORY, (Integer)this.clusterCfg.planner().estimatedNumberOfQueries().value(), partitionPruner, () -> this.logicalTopologyService.localLogicalTopology().version(), new ExecutionDistributionProviderImpl(this.placementDriver, this.systemViewManager));
        this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, mappingService::onPrimaryReplicaExpired);
        ExecutionServiceImpl<SqlRowHandler.RowWrapper> executionSrvc = this.registerService(ExecutionServiceImpl.create(this.clusterSrvc.topologyService(), msgSrvc, this.sqlSchemaManager, ddlCommandHandler, this.taskExecutor, SqlRowHandler.INSTANCE, mailboxRegistry, exchangeService, mappingService, executableTableRegistry, dependencyResolver, tableFunctionRegistry, this.clockService, this.killCommandHandler, new ExpressionFactoryImpl(Commons.typeFactory(), 1024, CACHE_FACTORY), 60000L));
        this.queryExecutor = this.registerService(new QueryExecutor(this.clusterSrvc.topologyService().localMember().name(), CACHE_FACTORY, 10000, new ParserServiceImpl(), this.taskExecutor, this.commonScheduler, this.clockService, this.schemaSyncService, prepareSvc, (CatalogService)this.catalogManager, executionSrvc, DEFAULT_PROPERTIES, this.txTracker, new QueryIdGenerator(nodeName.hashCode()), this.eventLog));
        this.queriesViewProvider.init(this.queryExecutor);
        this.clusterSrvc.topologyService().addEventHandler(executionSrvc);
        this.clusterSrvc.topologyService().addEventHandler((TopologyEventHandler)mailboxRegistry);
        this.registerService(this.sqlStatisticManager);
        this.services.forEach(LifecycleAware::start);
        this.killCommandHandler.register(new SqlQueryKillHandler());
        return CompletableFutures.nullCompletedFuture();
    }

    public synchronized CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.metricManager.unregisterSource("sql.client");
        ArrayList<LifecycleAware> services = new ArrayList<LifecycleAware>(this.services);
        this.services.clear();
        Collections.reverse(services);
        try {
            IgniteUtils.closeAll(services.stream().map(s -> s::stop));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<QueryMetadata> prepareSingleAsync(SqlProperties properties, @Nullable InternalTransaction transaction, String qry, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<QueryMetadata> completableFuture = this.prepareSingleAsync0(properties, transaction, qry, params);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AsyncSqlCursor<InternalSqlRow>> queryAsync(SqlProperties properties, HybridTimestampTracker observableTimeTracker, @Nullable InternalTransaction transaction, @Nullable CancellationToken cancellationToken, String qry, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            QueryTransactionContextImpl txContext = new QueryTransactionContextImpl(this.txManager, observableTimeTracker, transaction, this.txTracker);
            CompletableFuture<AsyncSqlCursor<InternalSqlRow>> completableFuture = this.queryExecutor.executeQuery(properties, txContext, qry, cancellationToken, params);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private <T extends LifecycleAware> T registerService(T service) {
        this.services.add(service);
        return service;
    }

    private CompletableFuture<QueryMetadata> prepareSingleAsync0(SqlProperties properties, @Nullable InternalTransaction explicitTransaction, String sql, Object ... params) {
        ParsedResult parsedResult;
        SqlProperties properties0 = SqlPropertiesHelper.chain(properties, DEFAULT_PROPERTIES);
        String schemaName = properties0.get(QueryProperty.DEFAULT_SCHEMA);
        Long queryTimeout = properties0.get(QueryProperty.QUERY_TIMEOUT);
        QueryCancel queryCancel = new QueryCancel();
        if (queryTimeout != 0L) {
            queryCancel.setTimeout(this.commonScheduler, queryTimeout);
        }
        CompletableFuture<ParsedResult> start = (parsedResult = this.queryExecutor.lookupParsedResultInCache(sql)) != null ? CompletableFuture.completedFuture(parsedResult) : CompletableFuture.supplyAsync(() -> this.parseAndCache(sql), this.taskExecutor);
        return start.thenCompose(result -> {
            ValidationHelper.validateParsedStatement(properties0, result);
            ValidationHelper.validateDynamicParameters(result.dynamicParamsCount(), params, false);
            HybridTimestamp timestamp = explicitTransaction != null ? explicitTransaction.startTimestamp() : this.clockService.now();
            CompletionStage f = this.prepareParsedStatement(schemaName, (ParsedResult)result, timestamp, queryCancel, params).thenApply(plan -> new QueryMetadata(plan.metadata(), plan.parameterMetadata()));
            try {
                queryCancel.add(arg_0 -> SqlQueryProcessor.lambda$prepareSingleAsync0$6((CompletableFuture)f, arg_0));
            }
            catch (QueryCancelledException queryCancelledException) {
                // empty catch block
            }
            return f;
        });
    }

    private CompletableFuture<QueryPlan> prepareParsedStatement(String schemaName, ParsedResult parsedResult, HybridTimestamp timestamp, QueryCancel queryCancel, Object[] params) {
        return this.waitForMetadata(timestamp).thenCompose(schema -> {
            SqlOperationContext ctx = SqlOperationContext.builder().queryId(UUID.randomUUID()).timeZoneId(DEFAULT_TIME_ZONE_ID).defaultSchemaName(schemaName).operationTime(timestamp).cancel(queryCancel).parameters(params).build();
            return this.prepareSvc.prepareAsync(parsedResult, ctx);
        });
    }

    private CompletableFuture<Void> waitForMetadata(HybridTimestamp timestamp) {
        return this.schemaSyncService.waitForMetadataCompleteness(timestamp);
    }

    @TestOnly
    public MetricManager metricManager() {
        return this.metricManager;
    }

    @TestOnly
    public SqlStatisticManager sqlStatisticManager() {
        return this.sqlStatisticManager;
    }

    private ParsedResult parseAndCache(String sql) {
        ParsedResult result = this.queryExecutor.parse(sql);
        if (result.queryType().supportsParseResultCaching()) {
            this.queryExecutor.updateParsedResultCache(sql, result);
        }
        return result;
    }

    public int openedCursors() {
        QueryExecutor executor = this.queryExecutor;
        if (executor == null) {
            return 0;
        }
        return (int)executor.runningQueries().stream().filter(info -> info.phase() == ExecutionPhase.EXECUTING && !info.script()).count();
    }

    @TestOnly
    public List<QueryInfo> runningQueries() {
        QueryExecutor executor = this.queryExecutor;
        if (executor == null) {
            return List.of();
        }
        return executor.runningQueries();
    }

    public List<SystemView<?>> systemViews() {
        return List.of(this.queriesViewProvider.get());
    }

    private static /* synthetic */ void lambda$prepareSingleAsync0$6(CompletableFuture f, boolean timeout) {
        String message = timeout ? "Query timeout" : "The query was cancelled while executing.";
        f.completeExceptionally((Throwable)new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, message));
    }

    private class SqlQueryKillHandler
    implements OperationKillHandler {
        private SqlQueryKillHandler() {
        }

        public CompletableFuture<Boolean> cancelAsync(String operationId) {
            Objects.requireNonNull(operationId, "operationId");
            UUID queryId = UUID.fromString(operationId);
            return SqlQueryProcessor.this.queryExecutor.cancelQuery(queryId);
        }

        public boolean local() {
            return true;
        }

        public CancellableOperationType type() {
            return CancellableOperationType.QUERY;
        }
    }

    public static class PrefetchCallback
    implements QueryPrefetchCallback {
        private final CompletableFuture<Void> prefetchFuture = new CompletableFuture();

        @Override
        public void onPrefetchComplete(@Nullable Throwable ex) {
            if (ex == null) {
                this.prefetchFuture.complete(null);
            } else {
                this.prefetchFuture.completeExceptionally(SqlExceptionMapperUtil.mapToPublicSqlException(ExceptionUtils.unwrapCause((Throwable)ex)));
            }
        }

        public CompletableFuture<Void> prefetchFuture() {
            return this.prefetchFuture;
        }
    }
}

