/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.JdbcTableMeta;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcMetaTablesResult
extends Response {
    private List<JdbcTableMeta> meta;

    public JdbcMetaTablesResult() {
    }

    public JdbcMetaTablesResult(List<JdbcTableMeta> meta) {
        Objects.requireNonNull(meta);
        this.meta = meta;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        packer.packInt(this.meta.size());
        for (JdbcTableMeta m : this.meta) {
            m.writeBinary(packer);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        int size = unpacker.unpackInt();
        this.meta = new ArrayList<JdbcTableMeta>(size);
        for (int i = 0; i < size; ++i) {
            JdbcTableMeta m = new JdbcTableMeta();
            m.readBinary(unpacker);
            this.meta.add(m);
        }
    }

    public List<JdbcTableMeta> meta() {
        return this.meta;
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaTablesResult.class, (Object)this);
    }
}

