/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.raft.commands.UpdateClusterStateCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.UpdateClusterStateCommandBuilder;
import org.apache.ignite.internal.cluster.management.raft.commands.UpdateClusterStateCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class UpdateClusterStateCommandImpl
implements UpdateClusterStateCommand,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 65;
    @IgniteToStringInclude
    private final ClusterState clusterState;

    private UpdateClusterStateCommandImpl(ClusterState clusterState) {
        this.clusterState = clusterState;
    }

    @Override
    public ClusterState clusterState() {
        return this.clusterState;
    }

    public MessageSerializer serializer() {
        return UpdateClusterStateCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(UpdateClusterStateCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 65;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateClusterStateCommandImpl otherMessage = (UpdateClusterStateCommandImpl)other;
        return Objects.equals(this.clusterState, otherMessage.clusterState);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterState);
        return result;
    }

    public UpdateClusterStateCommandImpl clone() {
        try {
            return (UpdateClusterStateCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateClusterStateCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterState != null) {
            this.clusterState.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterState != null) {
            this.clusterState.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements UpdateClusterStateCommandBuilder {
        private ClusterState clusterState;

        private Builder() {
        }

        @Override
        public UpdateClusterStateCommandBuilder clusterState(ClusterState clusterState) {
            Objects.requireNonNull(clusterState, "clusterState is not marked @Nullable");
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public ClusterState clusterState() {
            return this.clusterState;
        }

        @Override
        public UpdateClusterStateCommand build() {
            return new UpdateClusterStateCommandImpl(Objects.requireNonNull(this.clusterState, "clusterState is not marked @Nullable"));
        }
    }
}

