/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.iceberg.flink.source;

import static org.assertj.core.api.Assertions.assertThat;

import org.apache.avro.generic.GenericRecord;
import org.apache.iceberg.flink.AvroGenericRecordConverterBase;
import org.apache.iceberg.flink.DataGenerator;

public class TestRowDataToAvroGenericRecordConverter extends AvroGenericRecordConverterBase {
  @Override
  protected void testConverter(DataGenerator dataGenerator) {
    RowDataToAvroGenericRecordConverter converter =
        RowDataToAvroGenericRecordConverter.fromAvroSchema(dataGenerator.avroSchema());
    GenericRecord expected = dataGenerator.generateAvroGenericRecord();
    GenericRecord actual = converter.apply(dataGenerator.generateFlinkRowData());
    assertThat(actual).isEqualTo(expected);
  }
}
