/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.create.AlterViewAsDesc;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterViewAsOperation
extends DDLOperation<AlterViewAsDesc> {
    public AlterViewAsOperation(DDLOperationContext context, AlterViewAsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table oldview = this.context.getDb().getTable(((AlterViewAsDesc)this.desc).getViewName(), false);
        oldview.setViewOriginalText(((AlterViewAsDesc)this.desc).getOriginalText());
        oldview.setViewExpandedText(((AlterViewAsDesc)this.desc).getExpandedText());
        oldview.setFields(((AlterViewAsDesc)this.desc).getSchema());
        oldview.checkValidity(null);
        this.context.getDb().alterTable(((AlterViewAsDesc)this.desc).getViewName(), oldview, false, null, true);
        DDLUtils.addIfAbsentByName(new WriteEntity(oldview, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
        return 0;
    }
}

