/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.cluster;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.util.DirectionUtils;

@Explain(displayName="Clustered By", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableClusteredByDesc
extends AbstractAlterTableDesc {
    private static final long serialVersionUID = 1L;
    private final int numberBuckets;
    private final List<String> bucketColumns;
    private final List<Order> sortColumns;

    public AlterTableClusteredByDesc(TableName tableName, Map<String, String> partitionSpec, int numberBuckets, List<String> bucketColumns, List<Order> sortColumns) throws SemanticException {
        super(AlterTableType.CLUSTERED_BY, tableName, partitionSpec, null, false, false, null);
        this.numberBuckets = numberBuckets;
        this.bucketColumns = bucketColumns;
        this.sortColumns = sortColumns;
    }

    @Explain(displayName="number of buckets", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public int getNumberBuckets() {
        return this.numberBuckets;
    }

    @Explain(displayName="bucket columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getBucketColumns() {
        return this.bucketColumns;
    }

    public List<Order> getSortColumns() {
        return this.sortColumns;
    }

    @Explain(displayName="sort columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getSortColumnsExplain() {
        return this.sortColumns.stream().map(t -> t.getCol() + " " + DirectionUtils.codeToText(t.getOrder())).collect(Collectors.toList());
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

