/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

public abstract class AbstractAlterTableDesc
implements DDLDesc.DDLDescWithWriteId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final AlterTableType type;
    private final TableName tableName;
    private final Map<String, String> partitionSpec;
    private final ReplicationSpec replicationSpec;
    private final boolean isCascade;
    private final boolean expectView;
    private final Map<String, String> props;
    private Long writeId;

    public AbstractAlterTableDesc(AlterTableType type, TableName tableName, Map<String, String> partitionSpec, ReplicationSpec replicationSpec, boolean isCascade, boolean expectView, Map<String, String> props) throws SemanticException {
        this.type = type;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.replicationSpec = replicationSpec;
        this.isCascade = isCascade;
        this.expectView = expectView;
        this.props = props;
    }

    public AlterTableType getType() {
        return this.type;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Explain(displayName="partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Explain(displayName="cascade", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isCascade() {
        return this.isCascade;
    }

    public boolean expectView() {
        return this.expectView;
    }

    @Explain(displayName="properties", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getProps() {
        return this.props;
    }

    public EnvironmentContext getEnvironmentContext() {
        return null;
    }

    @Override
    public String getFullTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    public Long getWriteId() {
        return this.writeId;
    }
}

