/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.metrics.MapMetrics;

public class MapCapableJsonMetricsModule
extends MetricsModule {
    public MapCapableJsonMetricsModule(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples) {
        super(rateUnit, durationUnit, showSamples, MetricFilter.ALL);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addSerializers((Serializers)new SimpleSerializers((List)ImmutableList.of((Object)((Object)new MetricRegistrySerializer(this.version(), MetricFilter.ALL)), (Object)((Object)new MapMetricsBeanSerializer()))));
    }

    private static class MetricRegistrySerializer
    extends StdSerializer<MetricRegistry> {
        private final Version version;
        private final MetricFilter filter;

        private MetricRegistrySerializer(Version version, MetricFilter filter) {
            super(MetricRegistry.class);
            this.version = version;
            this.filter = filter;
        }

        public void serialize(MetricRegistry registry, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            SortedMetrics metrics = new SortedMetrics(registry, this.filter);
            json.writeStringField("version", this.version.toString());
            json.writeObjectField("gauges", metrics.getGauges());
            json.writeObjectField("counters", metrics.getCounters());
            json.writeObjectField("histograms", metrics.getHistograms());
            json.writeObjectField("meters", metrics.getMeters());
            json.writeObjectField("timers", metrics.getTimers());
            json.writeObjectField("mbeans", metrics.getMaps());
            json.writeEndObject();
        }
    }

    private static class MapMetricsBeanSerializer
    extends StdSerializer<MapMetrics> {
        private MapMetricsBeanSerializer() {
            super(MapMetrics.class);
        }

        public void serialize(MapMetrics map, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            for (Map.Entry<String, Integer> entry : map.get().entrySet()) {
                json.writeObjectField(entry.getKey(), (Object)entry.getValue());
            }
            json.writeEndObject();
        }
    }

    private static class SortedMetrics {
        private final TreeMap<String, Metric> gauges = new TreeMap();
        private final TreeMap<String, Metric> counters = new TreeMap();
        private final TreeMap<String, Metric> histograms = new TreeMap();
        private final TreeMap<String, Metric> meters = new TreeMap();
        private final TreeMap<String, Metric> timers = new TreeMap();
        private final TreeMap<String, Metric> maps = new TreeMap();

        public SortedMetrics(MetricRegistry registry, MetricFilter filter) {
            for (Map.Entry entry : registry.getMetrics().entrySet()) {
                String name = (String)entry.getKey();
                Metric metric = (Metric)entry.getValue();
                if (filter != null && !filter.matches(name, metric)) continue;
                if (metric instanceof Gauge) {
                    this.gauges.put(name, metric);
                    continue;
                }
                if (metric instanceof Counter) {
                    this.counters.put(name, metric);
                    continue;
                }
                if (metric instanceof Histogram) {
                    this.histograms.put(name, metric);
                    continue;
                }
                if (metric instanceof Timer) {
                    this.timers.put(name, metric);
                    continue;
                }
                if (!(metric instanceof MapMetrics)) continue;
                this.maps.put(name, metric);
            }
        }

        public TreeMap<String, Metric> getGauges() {
            return this.gauges;
        }

        public TreeMap<String, Metric> getCounters() {
            return this.counters;
        }

        public TreeMap<String, Metric> getHistograms() {
            return this.histograms;
        }

        public TreeMap<String, Metric> getMeters() {
            return this.meters;
        }

        public TreeMap<String, Metric> getTimers() {
            return this.timers;
        }

        public TreeMap<String, Metric> getMaps() {
            return this.maps;
        }
    }
}

