/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.Event;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public final class InputDataInformationEvent
extends Event {
    private final int sourceIndex;
    private int targetIndex;
    private final ByteBuffer userPayload;
    private String serializedPath;
    private final Object userPayloadObject;

    private InputDataInformationEvent(int srcIndex, ByteBuffer userPayload) {
        this.sourceIndex = srcIndex;
        this.userPayload = userPayload;
        this.userPayloadObject = null;
    }

    private InputDataInformationEvent(int srcIndex, Object userPayloadDeserialized, Object sigChanged) {
        this.sourceIndex = srcIndex;
        this.userPayloadObject = userPayloadDeserialized;
        this.userPayload = null;
    }

    public static InputDataInformationEvent createWithSerializedPayload(int srcIndex, ByteBuffer userPayload) {
        return new InputDataInformationEvent(srcIndex, userPayload);
    }

    public static InputDataInformationEvent createWithObjectPayload(int srcIndex, Object userPayloadDeserialized) {
        return new InputDataInformationEvent(srcIndex, userPayloadDeserialized, null);
    }

    public static InputDataInformationEvent createWithSerializedPath(int srcIndex, String serializedPath) {
        InputDataInformationEvent event = new InputDataInformationEvent(srcIndex, null);
        event.serializedPath = serializedPath;
        return event;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setTargetIndex(int target) {
        this.targetIndex = target;
    }

    public String getSerializedPath() {
        return this.serializedPath;
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }

    public Object getDeserializedUserPayload() {
        return this.userPayloadObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InputDataInformationEvent [sourceIndex=").append(this.sourceIndex).append(", targetIndex=").append(this.targetIndex).append(", serializedUserPayloadExists=").append(this.userPayload != null).append(", deserializedUserPayloadExists=").append(this.userPayloadObject != null);
        if (this.serializedPath != null) {
            sb.append(", serializedPath=").append(this.serializedPath);
        }
        sb.append("]");
        return sb.toString();
    }
}

