/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.net.InnerNode;
import org.apache.hadoop.net.InnerNodeImpl;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSTopologyNodeImpl
extends InnerNodeImpl {
    public static final Logger LOG = LoggerFactory.getLogger(DFSTopologyNodeImpl.class);
    static final InnerNodeImpl.Factory FACTORY = new Factory();
    private final HashMap<String, EnumMap<StorageType, Integer>> childrenStorageInfo = new HashMap();
    private final EnumMap<StorageType, Integer> storageTypeCounts = new EnumMap(StorageType.class);

    DFSTopologyNodeImpl(String path) {
        super(path);
    }

    DFSTopologyNodeImpl(String name, String location, InnerNode parent, int level) {
        super(name, location, parent, level);
    }

    public int getSubtreeStorageCount(StorageType type) {
        if (this.storageTypeCounts.containsKey(type)) {
            return this.storageTypeCounts.get(type);
        }
        return 0;
    }

    private void incStorageTypeCount(StorageType type) {
        if (this.storageTypeCounts.containsKey(type)) {
            this.storageTypeCounts.put(type, this.storageTypeCounts.get(type) + 1);
        } else {
            this.storageTypeCounts.put(type, 1);
        }
    }

    private void decStorageTypeCount(StorageType type) {
        int current = this.storageTypeCounts.get(type);
        if (--current == 0) {
            this.storageTypeCounts.remove(type);
        } else {
            this.storageTypeCounts.put(type, current);
        }
    }

    private void updateExistingDatanode(DatanodeDescriptor dnDescriptor) {
        if (this.childrenStorageInfo.containsKey(dnDescriptor.getName())) {
            boolean same = dnDescriptor.getStorageTypes().size() == this.childrenStorageInfo.get(dnDescriptor.getName()).keySet().size();
            for (StorageType type : this.childrenStorageInfo.get(dnDescriptor.getName()).keySet()) {
                same = same && dnDescriptor.hasStorageType(type);
            }
            if (same) {
                return;
            }
            DFSTopologyNodeImpl parent = (DFSTopologyNodeImpl)this.getParent();
            for (StorageType type : this.childrenStorageInfo.get(dnDescriptor.getName()).keySet()) {
                if (dnDescriptor.hasStorageType(type)) continue;
                this.childrenStorageInfo.get(dnDescriptor.getName()).remove(type);
                this.decStorageTypeCount(type);
                if (parent == null) continue;
                parent.childRemoveStorage(this.getName(), type);
            }
            for (StorageType type : dnDescriptor.getStorageTypes()) {
                if (this.childrenStorageInfo.get(dnDescriptor.getName()).containsKey(type)) continue;
                this.childrenStorageInfo.get(dnDescriptor.getName()).put(type, 1);
                this.incStorageTypeCount(type);
                if (parent == null) continue;
                parent.childAddStorage(this.getName(), type);
            }
        }
    }

    public boolean add(Node n) {
        LOG.debug("adding node {}", (Object)n.getName());
        if (!this.isAncestor(n)) {
            throw new IllegalArgumentException(n.getName() + ", which is located at " + n.getNetworkLocation() + ", is not a descendant of " + DFSTopologyNodeImpl.getPath((Node)this));
        }
        if (!(n instanceof DatanodeDescriptor)) {
            throw new IllegalArgumentException("Unexpected node type " + n.getClass().getName());
        }
        DatanodeDescriptor dnDescriptor = (DatanodeDescriptor)n;
        if (this.isParent(n)) {
            n.setParent((Node)this);
            n.setLevel(this.level + 1);
            Node prev = this.childrenMap.put(n.getName(), n);
            if (prev != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!((Node)this.children.get(i)).getName().equals(n.getName())) continue;
                    this.children.set(i, n);
                    this.updateExistingDatanode(dnDescriptor);
                    return false;
                }
            }
            this.children.add(n);
            ++this.numOfLeaves;
            if (!this.childrenStorageInfo.containsKey(dnDescriptor.getName())) {
                this.childrenStorageInfo.put(dnDescriptor.getName(), new EnumMap(StorageType.class));
            }
            for (StorageType st : dnDescriptor.getStorageTypes()) {
                this.childrenStorageInfo.get(dnDescriptor.getName()).put(st, 1);
                this.incStorageTypeCount(st);
            }
            return true;
        }
        String parentName = this.getNextAncestorName(n);
        Object parentNode = (InnerNode)this.childrenMap.get(parentName);
        if (parentNode == null) {
            parentNode = this.createParentNode(parentName);
            this.children.add(parentNode);
            this.childrenMap.put(parentNode.getName(), parentNode);
        }
        if (parentNode.add(n)) {
            ++this.numOfLeaves;
            if (!this.childrenStorageInfo.containsKey(parentNode.getName())) {
                this.childrenStorageInfo.put(parentNode.getName(), new EnumMap(StorageType.class));
                for (StorageType st : dnDescriptor.getStorageTypes()) {
                    this.childrenStorageInfo.get(parentNode.getName()).put(st, 1);
                }
            } else {
                EnumMap<StorageType, Integer> currentCount = this.childrenStorageInfo.get(parentNode.getName());
                for (StorageType st : dnDescriptor.getStorageTypes()) {
                    if (currentCount.containsKey(st)) {
                        currentCount.put(st, currentCount.get(st) + 1);
                        continue;
                    }
                    currentCount.put(st, 1);
                }
            }
            for (StorageType st : dnDescriptor.getStorageTypes()) {
                this.incStorageTypeCount(st);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    HashMap<String, EnumMap<StorageType, Integer>> getChildrenStorageInfo() {
        return this.childrenStorageInfo;
    }

    private DFSTopologyNodeImpl createParentNode(String parentName) {
        return new DFSTopologyNodeImpl(parentName, DFSTopologyNodeImpl.getPath((Node)this), (InnerNode)this, this.getLevel() + 1);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean remove(Node n) {
        LOG.debug("removing node {}", (Object)n.getName());
        if (!this.isAncestor(n)) {
            throw new IllegalArgumentException(n.getName() + ", which is located at " + n.getNetworkLocation() + ", is not a descendant of " + DFSTopologyNodeImpl.getPath((Node)this));
        }
        if (!(n instanceof DatanodeDescriptor)) {
            throw new IllegalArgumentException("Unexpected node type " + n.getClass().getName());
        }
        DatanodeDescriptor dnDescriptor = (DatanodeDescriptor)n;
        if (this.isParent(n)) {
            if (this.childrenMap.containsKey(n.getName())) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!((Node)this.children.get(i)).getName().equals(n.getName())) continue;
                    this.children.remove(i);
                    this.childrenMap.remove(n.getName());
                    this.childrenStorageInfo.remove(dnDescriptor.getName());
                    for (StorageType st : dnDescriptor.getStorageTypes()) {
                        this.decStorageTypeCount(st);
                    }
                    --this.numOfLeaves;
                    n.setParent(null);
                    return true;
                }
            }
            return false;
        }
        String parentName = this.getNextAncestorName(n);
        DFSTopologyNodeImpl parentNode = (DFSTopologyNodeImpl)((Object)this.childrenMap.get(parentName));
        if (parentNode == null) {
            return false;
        }
        boolean isRemoved = parentNode.remove(n);
        if (isRemoved) {
            EnumMap<StorageType, Integer> currentCount = this.childrenStorageInfo.get(parentNode.getName());
            EnumSet<StorageType> toRemove = EnumSet.noneOf(StorageType.class);
            for (StorageType st : dnDescriptor.getStorageTypes()) {
                int newCount = currentCount.get(st) - 1;
                if (newCount == 0) {
                    toRemove.add(st);
                }
                currentCount.put(st, newCount);
            }
            for (StorageType st : toRemove) {
                currentCount.remove(st);
            }
            for (StorageType st : dnDescriptor.getStorageTypes()) {
                this.decStorageTypeCount(st);
            }
            if (parentNode.getNumOfChildren() == 0) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!((Node)this.children.get(i)).getName().equals(parentName)) continue;
                    this.children.remove(i);
                    this.childrenMap.remove(parentName);
                    this.childrenStorageInfo.remove(parentNode.getName());
                    break;
                }
            }
            --this.numOfLeaves;
        }
        return isRemoved;
    }

    public synchronized void childAddStorage(String childName, StorageType type) {
        LOG.debug("child add storage: {}:{}", (Object)childName, (Object)type);
        Preconditions.checkArgument((boolean)this.childrenStorageInfo.containsKey(childName));
        EnumMap<StorageType, Integer> typeCount = this.childrenStorageInfo.get(childName);
        if (typeCount.containsKey(type)) {
            typeCount.put(type, typeCount.get(type) + 1);
        } else {
            typeCount.put(type, 1);
        }
        if (this.storageTypeCounts.containsKey(type)) {
            this.storageTypeCounts.put(type, this.storageTypeCounts.get(type) + 1);
        } else {
            this.storageTypeCounts.put(type, 1);
        }
        if (this.getParent() != null) {
            ((DFSTopologyNodeImpl)this.getParent()).childAddStorage(this.getName(), type);
        }
    }

    public synchronized void childRemoveStorage(String childName, StorageType type) {
        LOG.debug("child remove storage: {}:{}", (Object)childName, (Object)type);
        Preconditions.checkArgument((boolean)this.childrenStorageInfo.containsKey(childName));
        EnumMap<StorageType, Integer> typeCount = this.childrenStorageInfo.get(childName);
        Preconditions.checkArgument((boolean)typeCount.containsKey(type));
        if (typeCount.get(type) > 1) {
            typeCount.put(type, typeCount.get(type) - 1);
        } else {
            typeCount.remove(type);
        }
        Preconditions.checkArgument((boolean)this.storageTypeCounts.containsKey(type));
        if (this.storageTypeCounts.get(type) > 1) {
            this.storageTypeCounts.put(type, this.storageTypeCounts.get(type) - 1);
        } else {
            this.storageTypeCounts.remove(type);
        }
        if (this.getParent() != null) {
            ((DFSTopologyNodeImpl)this.getParent()).childRemoveStorage(this.getName(), type);
        }
    }

    static final class Factory
    extends InnerNodeImpl.Factory {
        private Factory() {
        }

        public InnerNodeImpl newInnerNode(String path) {
            return new DFSTopologyNodeImpl(path);
        }
    }
}

