/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server;

import java.util.Date;
import org.apache.hadoop.hbase.shaded.org.apache.jute.BinaryInputArchive;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Version;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.Request;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.RequestThrottler;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ServerCnxnHelper;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ServerStats;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ZooKeeperServerMXBean;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.CommitProcessor;

public class ZooKeeperServerBean
implements ZooKeeperServerMXBean,
ZKMBeanInfo {
    private final Date startTime = new Date();
    private final String name;
    protected final ZooKeeperServer zks;

    public ZooKeeperServerBean(ZooKeeperServer zks) {
        this.zks = zks;
        this.name = "StandaloneServer_port" + zks.getClientPort();
    }

    @Override
    public String getClientPort() {
        return Integer.toString(this.zks.getClientPort());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getStartTime() {
        return this.startTime.toString();
    }

    @Override
    public String getVersion() {
        return Version.getFullVersion();
    }

    @Override
    public double getAvgRequestLatency() {
        return this.zks.serverStats().getAvgLatency();
    }

    @Override
    public long getMaxRequestLatency() {
        return this.zks.serverStats().getMaxLatency();
    }

    @Override
    public long getMinRequestLatency() {
        return this.zks.serverStats().getMinLatency();
    }

    @Override
    public long getOutstandingRequests() {
        return this.zks.serverStats().getOutstandingRequests();
    }

    @Override
    public int getTickTime() {
        return this.zks.getTickTime();
    }

    @Override
    public void setTickTime(int tickTime) {
        this.zks.setTickTime(tickTime);
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.zks.getMaxClientCnxnsPerHost();
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        if (this.zks.serverCnxnFactory != null) {
            this.zks.serverCnxnFactory.setMaxClientCnxnsPerHost(max);
        }
        if (this.zks.secureServerCnxnFactory != null) {
            this.zks.secureServerCnxnFactory.setMaxClientCnxnsPerHost(max);
        }
    }

    @Override
    public int getMinSessionTimeout() {
        return this.zks.getMinSessionTimeout();
    }

    @Override
    public void setMinSessionTimeout(int min) {
        this.zks.setMinSessionTimeout(min);
    }

    @Override
    public int getMaxSessionTimeout() {
        return this.zks.getMaxSessionTimeout();
    }

    @Override
    public void setMaxSessionTimeout(int max) {
        this.zks.setMaxSessionTimeout(max);
    }

    @Override
    public long getDataDirSize() {
        return this.zks.getDataDirSize();
    }

    @Override
    public long getLogDirSize() {
        return this.zks.getLogDirSize();
    }

    @Override
    public long getPacketsReceived() {
        return this.zks.serverStats().getPacketsReceived();
    }

    @Override
    public long getPacketsSent() {
        return this.zks.serverStats().getPacketsSent();
    }

    @Override
    public long getFsyncThresholdExceedCount() {
        return this.zks.serverStats().getFsyncThresholdExceedCount();
    }

    @Override
    public long getAuthFailedCount() {
        return this.zks.serverStats().getAuthFailedCount();
    }

    @Override
    public long getNonMTLSRemoteConnCount() {
        return this.zks.serverStats().getNonMTLSRemoteConnCount();
    }

    @Override
    public long getNonMTLSLocalConnCount() {
        return this.zks.serverStats().getNonMTLSLocalConnCount();
    }

    @Override
    public void resetLatency() {
        this.zks.serverStats().resetLatency();
    }

    @Override
    public void resetMaxLatency() {
        this.zks.serverStats().resetMaxLatency();
    }

    @Override
    public void resetFsyncThresholdExceedCount() {
        this.zks.serverStats().resetFsyncThresholdExceedCount();
    }

    @Override
    public void resetAuthFailedCount() {
        this.zks.serverStats().resetAuthFailedCount();
    }

    @Override
    public void resetNonMTLSConnCount() {
        this.zks.serverStats().resetNonMTLSRemoteConnCount();
        this.zks.serverStats().resetNonMTLSLocalConnCount();
    }

    @Override
    public void resetStatistics() {
        ServerStats serverStats = this.zks.serverStats();
        serverStats.resetRequestCounters();
        serverStats.resetLatency();
        serverStats.resetFsyncThresholdExceedCount();
        serverStats.resetAuthFailedCount();
        serverStats.resetNonMTLSRemoteConnCount();
        serverStats.resetNonMTLSLocalConnCount();
    }

    @Override
    public long getNumAliveConnections() {
        return this.zks.getNumAliveConnections();
    }

    @Override
    public String getSecureClientPort() {
        if (this.zks.secureServerCnxnFactory != null) {
            return Integer.toString(this.zks.secureServerCnxnFactory.getLocalPort());
        }
        return "";
    }

    @Override
    public String getSecureClientAddress() {
        if (this.zks.secureServerCnxnFactory != null) {
            return String.format("%s:%d", this.zks.secureServerCnxnFactory.getLocalAddress().getHostString(), this.zks.secureServerCnxnFactory.getLocalPort());
        }
        return "";
    }

    @Override
    public long getTxnLogElapsedSyncTime() {
        return this.zks.getTxnLogElapsedSyncTime();
    }

    @Override
    public int getJuteMaxBufferSize() {
        return BinaryInputArchive.maxBuffer;
    }

    @Override
    public int getLastClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getLastBufferSize();
    }

    @Override
    public int getMinClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getMinBufferSize();
    }

    @Override
    public int getMaxClientResponseSize() {
        return this.zks.serverStats().getClientResponseStats().getMaxBufferSize();
    }

    @Override
    public boolean getResponseCachingEnabled() {
        return this.zks.isResponseCachingEnabled();
    }

    @Override
    public void setResponseCachingEnabled(boolean isEnabled) {
        this.zks.setResponseCachingEnabled(isEnabled);
    }

    @Override
    public int getConnectionMaxTokens() {
        return this.zks.connThrottle().getMaxTokens();
    }

    @Override
    public void setConnectionMaxTokens(int val) {
        this.zks.connThrottle().setMaxTokens(val);
    }

    @Override
    public int getConnectionTokenFillTime() {
        return this.zks.connThrottle().getFillTime();
    }

    @Override
    public void setConnectionTokenFillTime(int val) {
        this.zks.connThrottle().setFillTime(val);
    }

    @Override
    public int getConnectionTokenFillCount() {
        return this.zks.connThrottle().getFillCount();
    }

    @Override
    public void setConnectionTokenFillCount(int val) {
        this.zks.connThrottle().setFillCount(val);
    }

    @Override
    public int getConnectionFreezeTime() {
        return this.zks.connThrottle().getFreezeTime();
    }

    @Override
    public void setConnectionFreezeTime(int val) {
        this.zks.connThrottle().setFreezeTime(val);
    }

    @Override
    public double getConnectionDropIncrease() {
        return this.zks.connThrottle().getDropIncrease();
    }

    @Override
    public void setConnectionDropIncrease(double val) {
        this.zks.connThrottle().setDropIncrease(val);
    }

    @Override
    public double getConnectionDropDecrease() {
        return this.zks.connThrottle().getDropDecrease();
    }

    @Override
    public void setConnectionDropDecrease(double val) {
        this.zks.connThrottle().setDropDecrease(val);
    }

    @Override
    public double getConnectionDecreaseRatio() {
        return this.zks.connThrottle().getDecreasePoint();
    }

    @Override
    public void setConnectionDecreaseRatio(double val) {
        this.zks.connThrottle().setDecreasePoint(val);
    }

    @Override
    public int getCommitProcMaxReadBatchSize() {
        return CommitProcessor.getMaxReadBatchSize();
    }

    @Override
    public void setCommitProcMaxReadBatchSize(int size) {
        CommitProcessor.setMaxReadBatchSize(size);
    }

    @Override
    public int getCommitProcMaxCommitBatchSize() {
        return CommitProcessor.getMaxCommitBatchSize();
    }

    @Override
    public void setCommitProcMaxCommitBatchSize(int size) {
        CommitProcessor.setMaxCommitBatchSize(size);
    }

    @Override
    public long getFlushDelay() {
        return this.zks.getFlushDelay();
    }

    @Override
    public void setFlushDelay(long delay) {
        ZooKeeperServer.setFlushDelay(delay);
    }

    @Override
    public int getThrottledOpWaitTime() {
        return ZooKeeperServer.getThrottledOpWaitTime();
    }

    @Override
    public void setThrottledOpWaitTime(int val) {
        ZooKeeperServer.setThrottledOpWaitTime(val);
    }

    @Override
    public int getRequestThrottleLimit() {
        return RequestThrottler.getMaxRequests();
    }

    @Override
    public void setRequestThrottleLimit(int requests) {
        RequestThrottler.setMaxRequests(requests);
    }

    @Override
    public int getRequestThrottleStallTime() {
        return RequestThrottler.getStallTime();
    }

    @Override
    public void setRequestThrottleStallTime(int time) {
        RequestThrottler.setStallTime(time);
    }

    @Override
    public boolean getRequestThrottleDropStale() {
        return RequestThrottler.getDropStaleRequests();
    }

    @Override
    public void setRequestThrottleDropStale(boolean drop) {
        RequestThrottler.setDropStaleRequests(drop);
    }

    @Override
    public long getMaxWriteQueuePollTime() {
        return this.zks.getMaxWriteQueuePollTime();
    }

    @Override
    public void setMaxWriteQueuePollTime(long delay) {
        ZooKeeperServer.setMaxWriteQueuePollTime(delay);
    }

    @Override
    public boolean getRequestStaleLatencyCheck() {
        return Request.getStaleLatencyCheck();
    }

    @Override
    public void setRequestStaleLatencyCheck(boolean check) {
        Request.setStaleLatencyCheck(check);
    }

    @Override
    public int getMaxBatchSize() {
        return this.zks.getMaxBatchSize();
    }

    @Override
    public void setMaxBatchSize(int size) {
        ZooKeeperServer.setMaxBatchSize(size);
    }

    @Override
    public boolean getRequestStaleConnectionCheck() {
        return Request.getStaleConnectionCheck();
    }

    @Override
    public void setRequestStaleConnectionCheck(boolean check) {
        Request.setStaleConnectionCheck(check);
    }

    @Override
    public int getLargeRequestMaxBytes() {
        return this.zks.getLargeRequestMaxBytes();
    }

    @Override
    public void setLargeRequestMaxBytes(int bytes) {
        this.zks.setLargeRequestMaxBytes(bytes);
    }

    @Override
    public int getLargeRequestThreshold() {
        return this.zks.getLargeRequestThreshold();
    }

    @Override
    public void setLargeRequestThreshold(int threshold) {
        this.zks.setLargeRequestThreshold(threshold);
    }

    @Override
    public int getMaxCnxns() {
        return ServerCnxnHelper.getMaxCnxns(this.zks.secureServerCnxnFactory, this.zks.serverCnxnFactory);
    }
}

