/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContextThreadLocal;
import net.sf.ehcache.constructs.nonstop.concurrency.InvalidLockStateAfterRejoinException;
import net.sf.ehcache.constructs.nonstop.concurrency.NonstopSync;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;

public class NonstopCacheLockProvider
implements CacheLockProvider {
    private final NonstopStore nonstopStore;
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal;

    public NonstopCacheLockProvider(NonstopStore nonstopStore, NonstopActiveDelegateHolder nonstopActiveDelegateHolder, ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal) {
        this.nonstopStore = nonstopStore;
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.explicitLockingContextThreadLocal = explicitLockingContextThreadLocal;
    }

    public Sync getSyncForKey(Object key) {
        return new NonstopSync(this.nonstopStore, this.nonstopActiveDelegateHolder, this.explicitLockingContextThreadLocal, key);
    }

    public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
        Sync[] syncs = new NonstopSync[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            syncs[i] = new NonstopSync(this.nonstopStore, this.nonstopActiveDelegateHolder, this.explicitLockingContextThreadLocal, keys[i]);
        }
        Object invalidLockStateException = null;
        ArrayList<Object> lockedKeys = new ArrayList<Object>();
        for (Sync nonstopSync : syncs) {
            try {
                ((NonstopSync)nonstopSync).lock(LockType.WRITE);
                lockedKeys.add(((NonstopSync)nonstopSync).getKey());
            }
            catch (NonStopCacheException e) {
                try {
                    this.unlockWriteLockForAllKeys(lockedKeys.toArray());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw new NonStopCacheException("WRITE lock could not be acquired for all keys, couldn't acquire lock starting at : " + ((NonstopSync)nonstopSync).getKey(), e);
            }
        }
        return syncs;
    }

    public Sync[] getAndWriteLockAllSyncForKeys(long timeout, Object ... keys) throws TimeoutException {
        Sync[] syncs = new NonstopSync[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            syncs[i] = new NonstopSync(this.nonstopStore, this.nonstopActiveDelegateHolder, this.explicitLockingContextThreadLocal, keys[i]);
        }
        ArrayList<Object> lockedKeys = new ArrayList<Object>();
        for (Sync nonstopSync : syncs) {
            try {
                ((NonstopSync)nonstopSync).tryLock(LockType.WRITE, timeout);
                lockedKeys.add(((NonstopSync)nonstopSync).getKey());
            }
            catch (InterruptedException e) {
                try {
                    this.unlockWriteLockForAllKeys(lockedKeys.toArray());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw new TimeoutException("Caught InterruptedException while trying to acquire lock for key: " + ((NonstopSync)nonstopSync).getKey());
            }
            catch (NonStopCacheException e) {
                try {
                    this.unlockWriteLockForAllKeys(lockedKeys.toArray());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw new NonStopCacheException("WRITE lock could not be acquired for all keys, couldn't acquire lock starting at : " + ((NonstopSync)nonstopSync).getKey(), e);
            }
        }
        return syncs;
    }

    public void unlockWriteLockForAllKeys(Object ... keys) {
        NonstopSync[] syncs = new NonstopSync[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            syncs[i] = new NonstopSync(this.nonstopStore, this.nonstopActiveDelegateHolder, this.explicitLockingContextThreadLocal, keys[i]);
        }
        InvalidLockStateAfterRejoinException invalidLockStateException = null;
        ArrayList<Object> invalidStateKeys = new ArrayList<Object>();
        for (NonstopSync nonstopSync : syncs) {
            try {
                nonstopSync.unlock(LockType.WRITE);
            }
            catch (InvalidLockStateAfterRejoinException e) {
                invalidLockStateException = e;
                invalidStateKeys.add(nonstopSync.getKey());
            }
        }
        if (invalidLockStateException != null) {
            throw new InvalidLockStateAfterRejoinException("Some locks were invalid on unlock - " + invalidStateKeys, invalidLockStateException);
        }
    }
}

