/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfigurableResource {
    private final Resource resource;
    private final double[] percentages;

    public ConfigurableResource(double[] percentages) {
        this.percentages = (double[])percentages.clone();
        this.resource = null;
    }

    public ConfigurableResource(Resource resource) {
        this.percentages = null;
        this.resource = resource;
    }

    public Resource getResource(Resource clusterResource) {
        if (this.percentages != null && clusterResource != null) {
            long memory = (long)((double)clusterResource.getMemorySize() * this.percentages[0]);
            int vcore = (int)((double)clusterResource.getVirtualCores() * this.percentages[1]);
            return Resource.newInstance((long)memory, (int)vcore);
        }
        return this.resource;
    }

    public Resource getResource() {
        return this.resource;
    }
}

