/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.util.Preconditions;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OperatorWindowMinMax<T>
implements Observable.Operator<T, T> {
    private final int windowSize;
    private final Comparator<? super T> comparator;
    private final Metric metric;

    public OperatorWindowMinMax(int windowSize, Comparator<? super T> comparator, Metric metric) {
        Preconditions.checkArgument(windowSize > 0, "windowSize must be greater than zero");
        Preconditions.checkNotNull(comparator, "comparator cannot be null");
        Preconditions.checkNotNull((Object)metric, "metric cannot be null");
        this.windowSize = windowSize;
        this.comparator = comparator;
        this.metric = metric;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            long count;
            final Deque<Long> q;
            final Map<Long, T> values;
            {
                super(x0);
                this.count = 0L;
                this.q = new ArrayDeque<Long>();
                this.values = new HashMap();
            }

            public void onCompleted() {
                child.onCompleted();
            }

            public void onError(Throwable e) {
                child.onError(e);
            }

            public void onNext(T t) {
                ++this.count;
                this.addToQueue(t);
                if (this.count >= (long)OperatorWindowMinMax.this.windowSize) {
                    Object value;
                    Long head = this.q.peekFirst();
                    if (head == this.count - (long)OperatorWindowMinMax.this.windowSize) {
                        this.values.remove(this.q.pollFirst());
                        value = this.values.get(this.q.peekFirst());
                    } else {
                        value = this.values.get(head);
                    }
                    child.onNext(value);
                }
            }

            private void addToQueue(T t) {
                Long v;
                while ((v = this.q.peekLast()) != null && OperatorWindowMinMax.this.compare(t, this.values.get(v)) <= 0) {
                    this.values.remove(this.q.pollLast());
                }
                this.values.put(this.count, t);
                this.q.offerLast(this.count);
            }

            public void setProducer(Producer producer) {
                child.setProducer(producer);
                producer.request((long)(OperatorWindowMinMax.this.windowSize - 1));
            }
        };
    }

    private int compare(T a, T b) {
        if (this.metric == Metric.MIN) {
            return this.comparator.compare(a, b);
        }
        return this.comparator.compare(b, a);
    }

    public static enum Metric {
        MIN,
        MAX;

    }
}

