/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;

public class AliyunCredentialsProvider
implements CredentialsProvider {
    private Credentials credentials = null;

    public AliyunCredentialsProvider(Configuration conf) throws IOException {
        String securityToken;
        String accessKeySecret;
        String accessKeyId;
        try {
            accessKeyId = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeyId");
            accessKeySecret = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeySecret");
        }
        catch (IOException e) {
            throw new InvalidCredentialsException((Throwable)e);
        }
        try {
            securityToken = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.securityToken");
        }
        catch (IOException e) {
            securityToken = null;
        }
        if (StringUtils.isEmpty((CharSequence)accessKeyId) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new InvalidCredentialsException("AccessKeyId and AccessKeySecret should not be null or empty.");
        }
        this.credentials = StringUtils.isNotEmpty((CharSequence)securityToken) ? new DefaultCredentials(accessKeyId, accessKeySecret, securityToken) : new DefaultCredentials(accessKeyId, accessKeySecret);
    }

    public void setCredentials(Credentials creds) {
        if (creds == null) {
            throw new InvalidCredentialsException("Credentials should not be null.");
        }
        this.credentials = creds;
    }

    public Credentials getCredentials() {
        if (this.credentials == null) {
            throw new InvalidCredentialsException("Invalid credentials");
        }
        return this.credentials;
    }
}

