/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.json.JsonUtils;

public class EntityListResponse
extends BaseResponse {
    @JsonSerialize(contentUsing=JsonUtils.NameIdentifierSerializer.class)
    @JsonDeserialize(contentUsing=JsonUtils.NameIdentifierDeserializer.class)
    @JsonProperty(value="identifiers")
    private final NameIdentifier[] idents;

    public EntityListResponse(NameIdentifier[] idents) {
        super(0);
        this.idents = idents;
    }

    public EntityListResponse() {
        this.idents = null;
    }

    public NameIdentifier[] identifiers() {
        return this.idents;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.idents != null ? 1 : 0) != 0, (Object)"identifiers must not be null");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityListResponse)) {
            return false;
        }
        EntityListResponse other = (EntityListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.idents, other.idents);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EntityListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.idents);
        return result;
    }

    @Override
    public String toString() {
        return "EntityListResponse(idents=" + Arrays.deepToString(this.idents) + ")";
    }
}

