/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.SerializationHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.logback.SpringProfileAction;
import org.springframework.boot.logging.logback.SpringProfileIfNestedWithinSecondPhaseElementSanityChecker;
import org.springframework.boot.logging.logback.SpringProfileModel;
import org.springframework.boot.logging.logback.SpringProfileModelHandler;
import org.springframework.boot.logging.logback.SpringPropertyAction;
import org.springframework.boot.logging.logback.SpringPropertyModel;
import org.springframework.boot.logging.logback.SpringPropertyModelHandler;
import org.springframework.core.CollectionFactory;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.util.function.ThrowingConsumer;

class SpringBootJoranConfigurator
extends JoranConfigurator {
    private final LoggingInitializationContext initializationContext;

    SpringBootJoranConfigurator(LoggingInitializationContext initializationContext) {
        this.initializationContext = initializationContext;
    }

    protected void sanityCheck(Model topModel) {
        super.sanityCheck(topModel);
        this.performCheck(new SpringProfileIfNestedWithinSecondPhaseElementSanityChecker(), topModel);
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(SpringPropertyModel.class, (handlerContext, handlerMic) -> new SpringPropertyModelHandler(this.context, this.initializationContext.getEnvironment()));
        defaultProcessor.addHandler(SpringProfileModel.class, (handlerContext, handlerMic) -> new SpringProfileModelHandler(this.context, this.initializationContext.getEnvironment()));
        super.addModelHandlerAssociations(defaultProcessor);
    }

    public void addElementSelectorAndActionAssociations(RuleStore ruleStore) {
        super.addElementSelectorAndActionAssociations(ruleStore);
        ruleStore.addRule(new ElementSelector("configuration/springProperty"), SpringPropertyAction::new);
        ruleStore.addRule(new ElementSelector("*/springProfile"), SpringProfileAction::new);
        ruleStore.addTransparentPathPart("springProfile");
    }

    public void buildModelInterpretationContext() {
        super.buildModelInterpretationContext();
        this.modelInterpretationContext.setConfiguratorSupplier(() -> {
            SpringBootJoranConfigurator configurator = new SpringBootJoranConfigurator(this.initializationContext);
            configurator.setContext(this.context);
            return configurator;
        });
    }

    boolean configureUsingAotGeneratedArtifacts() {
        if (!new PatternRules(this.getContext()).load()) {
            return false;
        }
        Model model = new ModelReader().read();
        this.processModel(model);
        this.registerSafeConfiguration(model);
        return true;
    }

    public void processModel(Model model) {
        super.processModel(model);
        if (!NativeDetector.inNativeImage() && this.isAotProcessingInProgress()) {
            this.getContext().putObject(BeanFactoryInitializationAotContribution.class.getName(), (Object)new LogbackConfigurationAotContribution(model, this.getModelInterpretationContext(), this.getContext()));
        }
    }

    private boolean isAotProcessingInProgress() {
        return Boolean.getBoolean("spring.aot.processing");
    }

    private static final class PatternRules {
        private static final String RESOURCE_LOCATION = "META-INF/spring/logback-pattern-rules";
        private final Context context;

        private PatternRules(Context context) {
            this.context = context;
        }

        private boolean load() {
            try {
                ClassPathResource resource = new ClassPathResource(RESOURCE_LOCATION);
                if (!resource.exists()) {
                    return false;
                }
                Properties properties = PropertiesLoaderUtils.loadProperties(resource);
                Map<String, String> patternRuleRegistry = this.getRegistryMap();
                for (String word : properties.stringPropertyNames()) {
                    patternRuleRegistry.put(word, properties.getProperty(word));
                }
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private Map<String, String> getRegistryMap() {
            HashMap patternRuleRegistry = (HashMap)this.context.getObject("PATTERN_RULE_REGISTRY");
            if (patternRuleRegistry == null) {
                patternRuleRegistry = new HashMap();
                this.context.putObject("PATTERN_RULE_REGISTRY", patternRuleRegistry);
            }
            return patternRuleRegistry;
        }

        private void save(GenerationContext generationContext) {
            Map<String, String> registryMap = this.getRegistryMap();
            byte[] rules = this.asBytes(registryMap);
            generationContext.getGeneratedFiles().handleFile(GeneratedFiles.Kind.RESOURCE, RESOURCE_LOCATION, new RequireNewOrMatchingContentFileHandler(rules));
            generationContext.getRuntimeHints().resources().registerPattern(RESOURCE_LOCATION);
            for (String ruleClassName : registryMap.values()) {
                generationContext.getRuntimeHints().reflection().registerType(TypeReference.of(ruleClassName), MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS);
            }
        }

        private byte[] asBytes(Map<String, String> patternRuleRegistry) {
            Properties properties = CollectionFactory.createSortedProperties(true);
            patternRuleRegistry.forEach(properties::setProperty);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                properties.store(bytes, "");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return bytes.toByteArray();
        }
    }

    private static final class ModelReader {
        private ModelReader() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Model read() {
            try (InputStream modelInput = this.getClass().getClassLoader().getResourceAsStream("META-INF/spring/logback-model");){
                Model model;
                try (ObjectInputStream input = new ObjectInputStream(modelInput);){
                    Model model2 = (Model)input.readObject();
                    ModelUtil.resetForReuse((Model)model2);
                    this.markIncludesAsHandled(model2);
                    model = model2;
                }
                return model;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load model from 'META-INF/spring/logback-model'", ex);
            }
        }

        private void markIncludesAsHandled(Model model) {
            if (model instanceof IncludeModel) {
                model.markAsHandled();
            }
            for (Model submodel : model.getSubModels()) {
                this.markIncludesAsHandled(submodel);
            }
        }
    }

    static final class LogbackConfigurationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final ModelWriter modelWriter;
        private final PatternRules patternRules;

        private LogbackConfigurationAotContribution(Model model, ModelInterpretationContext interpretationContext, Context context) {
            this.modelWriter = new ModelWriter(model, interpretationContext);
            this.patternRules = new PatternRules(context);
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            this.modelWriter.writeTo(generationContext);
            this.patternRules.save(generationContext);
        }
    }

    private static final class RequireNewOrMatchingContentFileHandler
    implements ThrowingConsumer<GeneratedFiles.FileHandler> {
        private final byte[] newContent;

        private RequireNewOrMatchingContentFileHandler(byte[] newContent) {
            this.newContent = newContent;
        }

        @Override
        public void acceptWithException(GeneratedFiles.FileHandler file) throws Exception {
            if (file.exists()) {
                byte[] existingContent = file.getContent().getInputStream().readAllBytes();
                if (!Arrays.equals(this.newContent, existingContent)) {
                    throw new IllegalStateException("Logging configuration differs from the configuration that has already been written. Update your logging configuration so that it is the same for each context");
                }
            } else {
                file.create(new ByteArrayResource(this.newContent));
            }
        }
    }

    private static final class ModelWriter {
        private static final String MODEL_RESOURCE_LOCATION = "META-INF/spring/logback-model";
        private final Model model;
        private final ModelInterpretationContext modelInterpretationContext;

        private ModelWriter(Model model, ModelInterpretationContext modelInterpretationContext) {
            this.model = model;
            this.modelInterpretationContext = modelInterpretationContext;
        }

        private void writeTo(GenerationContext generationContext) {
            byte[] serializedModel = this.serializeModel();
            generationContext.getGeneratedFiles().handleFile(GeneratedFiles.Kind.RESOURCE, MODEL_RESOURCE_LOCATION, new RequireNewOrMatchingContentFileHandler(serializedModel));
            generationContext.getRuntimeHints().resources().registerPattern(MODEL_RESOURCE_LOCATION);
            SerializationHints serializationHints = generationContext.getRuntimeHints().serialization();
            this.serializationTypes(this.model).forEach(serializationHints::registerType);
            this.reflectionTypes(this.model).forEach(type -> generationContext.getRuntimeHints().reflection().registerType(TypeReference.of(type), MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS));
        }

        private byte[] serializeModel() {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream output = new ObjectOutputStream(bytes);){
                output.writeObject(this.model);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return bytes.toByteArray();
        }

        private Set<Class<? extends Serializable>> serializationTypes(Model model) {
            HashSet<Class<? extends Serializable>> modelClasses = new HashSet<Class<? extends Serializable>>();
            Class<?> candidate = model.getClass();
            while (Model.class.isAssignableFrom(candidate)) {
                if (!modelClasses.add(candidate)) continue;
                ReflectionUtils.doWithFields(candidate, field -> {
                    Class<?> fieldType;
                    if (Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    ReflectionUtils.makeAccessible(field);
                    Object value = field.get(model);
                    if (value != null && Serializable.class.isAssignableFrom(fieldType = value.getClass())) {
                        modelClasses.add(fieldType);
                    }
                });
                candidate = candidate.getSuperclass();
            }
            for (Model submodel : model.getSubModels()) {
                modelClasses.addAll(this.serializationTypes(submodel));
            }
            return modelClasses;
        }

        private Set<Class<?>> reflectionTypes(Model model) {
            return this.reflectionTypes(model, () -> null);
        }

        private Set<Class<?>> reflectionTypes(Model model, Supplier<Object> parent) {
            HashSet reflectionTypes = new HashSet();
            Class<?> componentType = this.determineType(model, parent);
            if (componentType != null) {
                this.processComponent(componentType, reflectionTypes);
            }
            SingletonSupplier<Object> componentSupplier = SingletonSupplier.ofNullable(() -> this.instantiate(componentType));
            for (Model submodel : model.getSubModels()) {
                reflectionTypes.addAll(this.reflectionTypes(submodel, componentSupplier));
            }
            return reflectionTypes;
        }

        private Class<?> determineType(Model model, Supplier<Object> parentSupplier) {
            String className;
            if (model instanceof ComponentModel) {
                ComponentModel componentModel = (ComponentModel)model;
                v0 = componentModel.getClassName();
            } else {
                v0 = className = null;
            }
            if (className != null) {
                return this.loadImportType(className);
            }
            String tag = model.getTag();
            if (tag != null) {
                className = this.modelInterpretationContext.getDefaultNestedComponentRegistry().findDefaultComponentTypeByTag(tag);
                if (className != null) {
                    return this.loadImportType(className);
                }
                return this.inferTypeFromParent(parentSupplier, tag);
            }
            return null;
        }

        private Class<?> loadImportType(String className) {
            return this.loadComponentType(this.modelInterpretationContext.getImport(className));
        }

        private Class<?> inferTypeFromParent(Supplier<Object> parentSupplier, String tag) {
            Object parent = parentSupplier.get();
            if (parent != null) {
                try {
                    PropertySetter propertySetter = new PropertySetter(this.modelInterpretationContext.getBeanDescriptionCache(), parent);
                    Class typeFromPropertySetter = propertySetter.getClassNameViaImplicitRules(tag, AggregationType.AS_COMPLEX_PROPERTY, this.modelInterpretationContext.getDefaultNestedComponentRegistry());
                    return typeFromPropertySetter;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }

        private Class<?> loadComponentType(String componentType) {
            try {
                return ClassUtils.forName(this.modelInterpretationContext.subst(componentType), this.getClass().getClassLoader());
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to load component type '" + componentType + "'", ex);
            }
        }

        private Object instantiate(Class<?> type) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                return null;
            }
        }

        private void processComponent(Class<?> componentType, Set<Class<?>> reflectionTypes) {
            BeanDescription beanDescription = this.modelInterpretationContext.getBeanDescriptionCache().getBeanDescription(componentType);
            reflectionTypes.addAll(this.parameterTypesNames(beanDescription.getPropertyNameToAdder().values()));
            reflectionTypes.addAll(this.parameterTypesNames(beanDescription.getPropertyNameToSetter().values()));
            reflectionTypes.add(componentType);
        }

        private Collection<Class<?>> parameterTypesNames(Collection<Method> methods) {
            return methods.stream().filter(method -> !method.getDeclaringClass().equals(ContextAware.class) && !method.getDeclaringClass().equals(ContextAwareBase.class)).map(Method::getParameterTypes).flatMap(Stream::of).filter(type -> !type.isPrimitive() && !type.equals(String.class)).map(type -> type.isArray() ? type.getComponentType() : type).toList();
        }
    }
}

