/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.autoconfigure.security.servlet.StaticResourceRequest;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.WebApplicationContext;

public final class PathRequest {
    private PathRequest() {
    }

    public static StaticResourceRequest toStaticResources() {
        return StaticResourceRequest.INSTANCE;
    }

    public static H2ConsoleRequestMatcher toH2Console() {
        return new H2ConsoleRequestMatcher();
    }

    public static final class H2ConsoleRequestMatcher
    extends ApplicationContextRequestMatcher<H2ConsoleProperties> {
        private volatile RequestMatcher delegate;

        private H2ConsoleRequestMatcher() {
            super(H2ConsoleProperties.class);
        }

        @Override
        protected boolean ignoreApplicationContext(WebApplicationContext applicationContext) {
            return WebServerApplicationContext.hasServerNamespace(applicationContext, "management");
        }

        @Override
        protected void initialized(Supplier<H2ConsoleProperties> h2ConsoleProperties) {
            this.delegate = PathPatternRequestMatcher.withDefaults().matcher(h2ConsoleProperties.get().getPath() + "/**");
        }

        @Override
        protected boolean matches(HttpServletRequest request, Supplier<H2ConsoleProperties> context) {
            return this.delegate.matches(request);
        }
    }
}

