/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.grails.forge.build.gradle.GradleRepository;
import org.grails.forge.build.gradle.VersionRegexRepoFilter;
import org.grails.forge.build.gradle.VersionType;

public class DefaultGradleRepository
implements GradleRepository {
    private final int order;
    private final String url;
    private final String name;
    private final List<VersionType> versionTypes;
    private final List<VersionRegexRepoFilter> versionFilters;

    public DefaultGradleRepository(int order, String url) {
        this(order, url, null, Collections.emptyList());
    }

    public DefaultGradleRepository(int order, String url, String name, List<VersionRegexRepoFilter> versionFilters) {
        this(order, url, name, versionFilters, List.of(VersionType.SNAPSHOT, VersionType.RELEASE));
    }

    public DefaultGradleRepository(int order, String url, String name, List<VersionRegexRepoFilter> versionFilters, List<VersionType> versionTypes) {
        this.order = order;
        this.url = url;
        this.name = name;
        this.versionFilters = versionFilters;
        this.versionTypes = versionTypes;
        if (versionTypes == null || versionTypes.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one version type");
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public List<VersionRegexRepoFilter> getVersionFilters() {
        return this.versionFilters;
    }

    public List<VersionType> getVersionTypes() {
        return this.versionTypes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultGradleRepository that = (DefaultGradleRepository)obj;
        return this.order == that.order && Objects.equals(this.url, that.url) && Objects.equals(this.name, that.name) && Objects.equals(this.versionFilters, that.versionFilters);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.url, this.name, this.versionFilters);
    }

    @Override
    @NonNull
    public String toSnippet(String basePadding) {
        String indent = "   ";
        StringBuilder snippet = new StringBuilder();
        snippet.append("maven {\n");
        snippet.append(basePadding).append(indent).append("url = '").append(this.url).append("'\n");
        if (this.name != null && !this.name.isEmpty()) {
            snippet.append(basePadding).append(indent).append("name = '").append(this.name).append("'\n");
        }
        for (VersionRegexRepoFilter filter2 : this.versionFilters) {
            snippet.append(basePadding).append(indent).append("content {\n").append(basePadding).append(indent).append(indent).append("includeVersionByRegex('").append(filter2.groupRegex()).append("', '").append(filter2.artifactRegex()).append("', '").append(filter2.versionRegex()).append("')").append("\n").append(basePadding).append(indent).append("}\n");
        }
        if (this.versionTypes.size() == 1) {
            snippet.append(basePadding).append(indent).append("mavenContent {\n");
            for (VersionType versionType : this.versionTypes) {
                if (versionType == VersionType.SNAPSHOT) {
                    snippet.append(basePadding).append(indent).append(indent).append("snapshotsOnly()").append("\n");
                    continue;
                }
                snippet.append(basePadding).append(indent).append(indent).append("releasesOnly()").append("\n");
            }
            snippet.append(basePadding).append(indent).append("}\n");
        }
        snippet.append(basePadding).append("}");
        return snippet.toString();
    }

    public String toString() {
        String versionTypes = this.versionTypes.stream().map(Enum::name).collect(Collectors.joining(","));
        return "GradleRepository(order=" + this.order + ", url=" + this.url + ", name=" + this.name + ", versionFilters=" + String.valueOf(this.versionFilters) + ", versionTypes=[" + versionTypes + "])";
    }
}

