/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;

public abstract class LocalPathPrefixComposerFactorySupport
implements LocalPathPrefixComposerFactory {
    protected static final String CONF_PROP_SPLIT = "aether.enhancedLocalRepository.split";
    protected static final boolean DEFAULT_SPLIT = false;
    protected static final String CONF_PROP_LOCAL_PREFIX = "aether.enhancedLocalRepository.localPrefix";
    protected static final String DEFAULT_LOCAL_PREFIX = "installed";
    protected static final String CONF_PROP_SPLIT_LOCAL = "aether.enhancedLocalRepository.splitLocal";
    protected static final boolean DEFAULT_SPLIT_LOCAL = false;
    protected static final String CONF_PROP_REMOTE_PREFIX = "aether.enhancedLocalRepository.remotePrefix";
    protected static final String DEFAULT_REMOTE_PREFIX = "cached";
    protected static final String CONF_PROP_SPLIT_REMOTE = "aether.enhancedLocalRepository.splitRemote";
    protected static final boolean DEFAULT_SPLIT_REMOTE = false;
    protected static final String CONF_PROP_SPLIT_REMOTE_REPOSITORY = "aether.enhancedLocalRepository.splitRemoteRepository";
    protected static final boolean DEFAULT_SPLIT_REMOTE_REPOSITORY = false;
    protected static final String CONF_PROP_SPLIT_REMOTE_REPOSITORY_LAST = "aether.enhancedLocalRepository.splitRemoteRepositoryLast";
    protected static final boolean DEFAULT_SPLIT_REMOTE_REPOSITORY_LAST = false;
    protected static final String CONF_PROP_RELEASES_PREFIX = "aether.enhancedLocalRepository.releasesPrefix";
    protected static final String DEFAULT_RELEASES_PREFIX = "releases";
    protected static final String CONF_PROP_SNAPSHOTS_PREFIX = "aether.enhancedLocalRepository.snapshotsPrefix";
    protected static final String DEFAULT_SNAPSHOTS_PREFIX = "snapshots";

    protected boolean isSplit(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONF_PROP_SPLIT);
    }

    protected String getLocalPrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, DEFAULT_LOCAL_PREFIX, CONF_PROP_LOCAL_PREFIX);
    }

    protected boolean isSplitLocal(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONF_PROP_SPLIT_LOCAL);
    }

    protected String getRemotePrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, DEFAULT_REMOTE_PREFIX, CONF_PROP_REMOTE_PREFIX);
    }

    protected boolean isSplitRemote(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONF_PROP_SPLIT_REMOTE);
    }

    protected boolean isSplitRemoteRepository(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONF_PROP_SPLIT_REMOTE_REPOSITORY);
    }

    protected boolean isSplitRemoteRepositoryLast(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONF_PROP_SPLIT_REMOTE_REPOSITORY_LAST);
    }

    protected String getReleasesPrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, DEFAULT_RELEASES_PREFIX, CONF_PROP_RELEASES_PREFIX);
    }

    protected String getSnapshotsPrefix(RepositorySystemSession session) {
        return ConfigUtils.getString(session, DEFAULT_SNAPSHOTS_PREFIX, CONF_PROP_SNAPSHOTS_PREFIX);
    }

    protected static abstract class LocalPathPrefixComposerSupport
    implements LocalPathPrefixComposer {
        protected final boolean split;
        protected final String localPrefix;
        protected final boolean splitLocal;
        protected final String remotePrefix;
        protected final boolean splitRemote;
        protected final boolean splitRemoteRepository;
        protected final boolean splitRemoteRepositoryLast;
        protected final String releasesPrefix;
        protected final String snapshotsPrefix;

        protected LocalPathPrefixComposerSupport(boolean split, String localPrefix, boolean splitLocal, String remotePrefix, boolean splitRemote, boolean splitRemoteRepository, boolean splitRemoteRepositoryLast, String releasesPrefix, String snapshotsPrefix) {
            this.split = split;
            this.localPrefix = localPrefix;
            this.splitLocal = splitLocal;
            this.remotePrefix = remotePrefix;
            this.splitRemote = splitRemote;
            this.splitRemoteRepository = splitRemoteRepository;
            this.splitRemoteRepositoryLast = splitRemoteRepositoryLast;
            this.releasesPrefix = releasesPrefix;
            this.snapshotsPrefix = snapshotsPrefix;
        }

        @Override
        public String getPathPrefixForLocalArtifact(Artifact artifact) {
            if (!this.split) {
                return null;
            }
            String result = this.localPrefix;
            if (this.splitLocal) {
                result = result + "/" + (artifact.isSnapshot() ? this.snapshotsPrefix : this.releasesPrefix);
            }
            return result;
        }

        @Override
        public String getPathPrefixForRemoteArtifact(Artifact artifact, RemoteRepository repository) {
            if (!this.split) {
                return null;
            }
            String result = this.remotePrefix;
            if (!this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            if (this.splitRemote) {
                result = result + "/" + (artifact.isSnapshot() ? this.snapshotsPrefix : this.releasesPrefix);
            }
            if (this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            return result;
        }

        @Override
        public String getPathPrefixForLocalMetadata(Metadata metadata) {
            if (!this.split) {
                return null;
            }
            String result = this.localPrefix;
            if (this.splitLocal) {
                result = result + "/" + (this.isSnapshot(metadata) ? this.snapshotsPrefix : this.releasesPrefix);
            }
            return result;
        }

        @Override
        public String getPathPrefixForRemoteMetadata(Metadata metadata, RemoteRepository repository) {
            if (!this.split) {
                return null;
            }
            String result = this.remotePrefix;
            if (!this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            if (this.splitRemote) {
                result = result + "/" + (this.isSnapshot(metadata) ? this.snapshotsPrefix : this.releasesPrefix);
            }
            if (this.splitRemoteRepositoryLast && this.splitRemoteRepository) {
                result = result + "/" + repository.getId();
            }
            return result;
        }

        protected boolean isSnapshot(Metadata metadata) {
            return !metadata.getVersion().isEmpty() && metadata.getVersion().endsWith("-SNAPSHOT");
        }
    }
}

