/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.test;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.Project;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.FeaturePhase;
import org.grails.forge.feature.test.Spock;
import org.grails.forge.feature.test.template.groovyJunit;
import org.grails.forge.feature.test.template.spock;
import org.grails.forge.options.DefaultTestRockerModelProvider;
import org.grails.forge.options.Language;
import org.grails.forge.options.Options;
import org.grails.forge.options.TestFramework;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class GebWithTestcontainers
implements DefaultFeature {
    private final Spock spock;

    public GebWithTestcontainers(Spock spock2) {
        this.spock = spock2;
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return applicationType == ApplicationType.WEB && options.getTestFramework() != TestFramework.JUNIT;
    }

    @Override
    @NonNull
    public String getName() {
        return "geb-with-testcontainers";
    }

    @Override
    public String getTitle() {
        return "Geb Functional Testing for Grails with Testcontainers";
    }

    @Override
    @NonNull
    public String getDescription() {
        return "This plugins configure Geb for Grails framework to write automation tests that run with Testcontainers.";
    }

    @Override
    public String getCategory() {
        return "Testing";
    }

    @Override
    public int getOrder() {
        return FeaturePhase.TEST.getOrder();
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.WEB_PLUGIN;
    }

    @Override
    public String getDocumentation() {
        return "https://github.com/apache/grails-geb#readme";
    }

    @Override
    public String getThirdPartyDocumentation() {
        return "https://groovy.apache.org/geb/manual/current/";
    }

    @Override
    public void processSelectedFeatures(FeatureContext featureContext) {
        if (!featureContext.isPresent(Spock.class) && this.spock != null) {
            featureContext.addFeature(this.spock);
        }
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-geb").integrationTestImplementationTestFixtures());
        Project project = generatorContext.getProject();
        DefaultTestRockerModelProvider provider = new DefaultTestRockerModelProvider(org.grails.forge.feature.test.template.spock.template(project), groovyJunit.template(project));
        generatorContext.addTemplate("applicationTest", new RockerTemplate(generatorContext.getIntegrationTestSourcePath("/{packagePath}/{className}"), provider.findModel(Language.DEFAULT_OPTION, generatorContext.getTestFramework())));
    }
}

