/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.query.Query;

public abstract class AbstractPersistentCollection
implements PersistentCollection,
Serializable {
    protected final transient Session session;
    protected final transient AssociationQueryExecutor indexer;
    protected final transient Class childType;
    protected boolean initialized;
    protected Object initializing;
    protected Serializable associationKey;
    protected Collection keys;
    protected boolean dirty = false;
    protected final Collection collection;
    protected int originalSize;
    protected boolean proxyEntities = false;

    protected AbstractPersistentCollection(Class childType, Session session, Collection collection) {
        this.childType = childType;
        this.collection = collection;
        this.session = session;
        this.initializing = Boolean.FALSE;
        this.initialized = true;
        this.indexer = null;
        this.markDirty();
    }

    protected AbstractPersistentCollection(final Association association, Serializable associationKey, final Session session, Collection collection) {
        this.collection = collection;
        this.session = session;
        this.associationKey = associationKey;
        this.proxyEntities = ((Property)association.getMapping().getMappedForm()).isLazy();
        this.childType = association.getAssociatedEntity().getJavaClass();
        this.indexer = new AssociationQueryExecutor(){

            @Override
            public boolean doesReturnKeys() {
                return true;
            }

            public List query(Object primaryKey) {
                Association inverseSide = association.getInverseSide();
                Query query = session.createQuery(association.getAssociatedEntity().getJavaClass());
                query.eq(inverseSide.getName(), primaryKey);
                query.projections().id();
                return query.list();
            }

            @Override
            public PersistentEntity getIndexedEntity() {
                return association.getAssociatedEntity();
            }
        };
    }

    protected AbstractPersistentCollection(Collection keys, Class childType, Session session, Collection collection) {
        this.session = session;
        this.keys = keys;
        this.childType = childType;
        this.collection = collection;
        this.indexer = null;
    }

    protected AbstractPersistentCollection(Serializable associationKey, Session session, AssociationQueryExecutor indexer, Collection collection) {
        this.session = session;
        this.associationKey = associationKey;
        this.indexer = indexer;
        this.collection = collection;
        this.childType = indexer.getIndexedEntity().getJavaClass();
    }

    public void setProxyEntities(boolean proxyEntities) {
        this.proxyEntities = proxyEntities;
    }

    @Override
    public boolean hasChanged() {
        return this.isDirty();
    }

    @Override
    public int getOriginalSize() {
        return this.originalSize;
    }

    @Override
    public boolean hasGrown() {
        return this.isInitialized() && this.size() > this.originalSize;
    }

    @Override
    public boolean hasShrunk() {
        return this.isInitialized() && this.size() < this.originalSize;
    }

    @Override
    public boolean hasChangedSize() {
        return this.isInitialized() && this.size() != this.originalSize;
    }

    @Override
    public Iterator iterator() {
        this.initialize();
        final Iterator iterator = this.collection.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                AbstractPersistentCollection.this.markDirty();
            }
        };
    }

    @Override
    public int size() {
        this.initialize();
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.initialize();
        return this.collection.contains(o);
    }

    public boolean add(Object o) {
        this.initialize();
        boolean added = this.collection.add(o);
        if (added) {
            this.markDirty();
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        this.initialize();
        boolean remove = this.collection.remove(o);
        if (remove) {
            this.markDirty();
        }
        return remove;
    }

    @Override
    public void clear() {
        this.initialize();
        this.collection.clear();
        this.markDirty();
    }

    @Override
    public boolean equals(Object o) {
        this.initialize();
        return this.collection.equals(o);
    }

    @Override
    public int hashCode() {
        this.initialize();
        return this.collection.hashCode();
    }

    public String toString() {
        this.initialize();
        return this.collection.toString();
    }

    public boolean removeAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.removeAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        this.initialize();
        return this.collection.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.initialize();
        return this.collection.toArray(a);
    }

    public boolean containsAll(Collection c) {
        this.initialize();
        return this.collection.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.addAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.retainAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitializing(Boolean initializing) {
        this.initializing = initializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (this.initializing != null) {
            return;
        }
        this.setInitializing(Boolean.TRUE);
        try {
            if (this.isInitialized()) {
                return;
            }
            Session session = this.session;
            if (session == null) {
                throw new IllegalStateException("PersistentCollection of type " + this.getClass().getName() + " should have been initialized before serialization.");
            }
            this.initialized = true;
            Class childType = this.childType;
            if (this.associationKey == null) {
                Collection keys = this.keys;
                if (keys != null) {
                    this.loadInverseChildKeys(session, childType, keys);
                }
            } else {
                List results = this.indexer.query(this.associationKey);
                if (this.indexer.doesReturnKeys()) {
                    PersistentEntity entity = this.indexer.getIndexedEntity();
                    if (entity != null) {
                        this.loadInverseChildKeys(session, entity.getJavaClass(), results);
                    } else if (childType != null) {
                        this.loadInverseChildKeys(session, childType, results);
                    }
                } else {
                    this.addAll((Collection)results);
                }
            }
            this.originalSize = this.size();
        }
        finally {
            this.setInitializing(Boolean.FALSE);
        }
    }

    protected void loadInverseChildKeys(Session session, Class childType, Collection keys) {
        if (!keys.isEmpty()) {
            if (this.proxyEntities) {
                for (Object key : keys) {
                    this.add(session.proxy(childType, (Serializable)key));
                }
            } else {
                this.addAll((Collection)session.retrieveAll(childType, keys));
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void resetDirty() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        if (!this.currentlyInitializing()) {
            this.dirty = true;
        }
    }

    protected boolean currentlyInitializing() {
        return this.initializing != null && this.initializing.equals(Boolean.TRUE);
    }
}

