/*
 * Decompiled with CFR 0.152.
 */
package grails.validation;

import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.gorm.validation.ConstrainedProperty;
import grails.util.GrailsNameUtils;
import grails.validation.ASTValidateableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.syntax.Token;
import org.grails.compiler.injection.ASTValidationErrorsHelper;
import org.grails.web.plugins.support.ValidationSupport;

public class DefaultASTValidateableHelper
implements ASTValidateableHelper {
    private static final String CONSTRAINED_PROPERTIES_PROPERTY_NAME = "$constraints";
    private static final String VALIDATE_METHOD_NAME = "validate";

    @Override
    public void injectValidateableCode(ClassNode classNode, boolean defaultNullable) {
        ASTValidationErrorsHelper errorsHelper = new ASTValidationErrorsHelper();
        errorsHelper.injectErrorsCode(classNode);
        this.addConstraintsField(classNode);
        this.addStaticInitializer(classNode);
        this.addGetConstraintsMethod(classNode, defaultNullable);
        this.addValidateMethod(classNode);
    }

    protected void addConstraintsField(ClassNode classNode) {
        FieldNode field = classNode.getField(CONSTRAINED_PROPERTIES_PROPERTY_NAME);
        if (field == null || !field.getDeclaringClass().equals(classNode)) {
            classNode.addField(CONSTRAINED_PROPERTIES_PROPERTY_NAME, 10, new ClassNode(Map.class), new ConstantExpression(null));
        }
    }

    private void addStaticInitializer(ClassNode classNode) {
        BinaryExpression nullOutConstrainedPropertiesExpression = new BinaryExpression(new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol(100, 0, 0), new ConstantExpression(null));
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(new ExpressionStatement(nullOutConstrainedPropertiesExpression));
        classNode.addStaticInitializerStatements(statements, true);
    }

    protected void addGetConstraintsMethod(ClassNode classNode, boolean defaultNullable) {
        String getConstraintsMethodName = "getConstraints";
        MethodNode getConstraintsMethod = classNode.getMethod("getConstraints", GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (getConstraintsMethod == null || !getConstraintsMethod.getDeclaringClass().equals(classNode)) {
            BooleanExpression isConstraintsPropertyNull = new BooleanExpression(new BinaryExpression(new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol(123, 0, 0), new ConstantExpression(null)));
            BlockStatement ifConstraintsPropertyIsNullBlockStatement = new BlockStatement();
            ArgumentListExpression getConstrainedPropertiesForClassArguments = new ArgumentListExpression();
            getConstrainedPropertiesForClassArguments.addExpression(new VariableExpression("this"));
            getConstrainedPropertiesForClassArguments.addExpression(new ConstantExpression(defaultNullable));
            StaticMethodCallExpression getConstraintsMethodCall = new StaticMethodCallExpression(ClassHelper.make(ValidationSupport.class), "getConstrainedPropertiesForClass", getConstrainedPropertiesForClassArguments);
            BinaryExpression initializeConstraintsFieldExpression = new BinaryExpression(new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol(100, 0, 0), getConstraintsMethodCall);
            IfStatement ifConstraintsPropertyIsNullStatement = new IfStatement(isConstraintsPropertyNull, ifConstraintsPropertyIsNullBlockStatement, new ExpressionStatement(new EmptyExpression()));
            ifConstraintsPropertyIsNullBlockStatement.addStatement(new ExpressionStatement(initializeConstraintsFieldExpression));
            if (!defaultNullable) {
                Map<String, ClassNode> propertiesToConstrain = this.getPropertiesToEnsureConstraintsFor(classNode);
                for (Map.Entry<String, ClassNode> entry : propertiesToConstrain.entrySet()) {
                    String propertyName = entry.getKey();
                    ClassNode propertyType = entry.getValue();
                    String cpName = "$" + propertyName + "$constrainedProperty";
                    ArgumentListExpression constrainedPropertyConstructorArgumentList = new ArgumentListExpression();
                    constrainedPropertyConstructorArgumentList.addExpression(new ClassExpression(classNode));
                    constrainedPropertyConstructorArgumentList.addExpression(new ConstantExpression(propertyName));
                    constrainedPropertyConstructorArgumentList.addExpression(new ClassExpression(propertyType));
                    ConstructorCallExpression constrainedPropertyCtorCallExpression = new ConstructorCallExpression(new ClassNode(ConstrainedProperty.class), constrainedPropertyConstructorArgumentList);
                    DeclarationExpression declareConstrainedPropertyExpression = new DeclarationExpression(new VariableExpression(cpName, ClassHelper.OBJECT_TYPE), Token.newSymbol(100, 0, 0), (Expression)constrainedPropertyCtorCallExpression);
                    ArgumentListExpression applyConstraintMethodArgumentList = new ArgumentListExpression();
                    applyConstraintMethodArgumentList.addExpression(new ConstantExpression("nullable"));
                    applyConstraintMethodArgumentList.addExpression(new ConstantExpression(defaultNullable));
                    MethodCallExpression applyNullableConstraintMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(cpName), "applyConstraint", (Expression)applyConstraintMethodArgumentList);
                    ArgumentListExpression putMethodArgumentList = new ArgumentListExpression();
                    putMethodArgumentList.addExpression(new ConstantExpression(propertyName));
                    putMethodArgumentList.addExpression(new VariableExpression(cpName));
                    MethodCallExpression addToConstraintsMapExpression = new MethodCallExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), "put", (Expression)putMethodArgumentList);
                    BlockStatement addNullableConstraintBlock = new BlockStatement();
                    addNullableConstraintBlock.addStatement(new ExpressionStatement(declareConstrainedPropertyExpression));
                    addNullableConstraintBlock.addStatement(new ExpressionStatement(applyNullableConstraintMethodCallExpression));
                    addNullableConstraintBlock.addStatement(new ExpressionStatement(addToConstraintsMapExpression));
                    MethodCallExpression constraintsMapContainsKeyExpression = new MethodCallExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME, ClassHelper.make(Map.class)), "containsKey", (Expression)new ArgumentListExpression(new ConstantExpression(propertyName)));
                    BooleanExpression ifPropertyIsAlreadyConstrainedExpression = new BooleanExpression(constraintsMapContainsKeyExpression);
                    IfStatement ifPropertyIsAlreadyConstrainedStatement = new IfStatement(ifPropertyIsAlreadyConstrainedExpression, new ExpressionStatement(new EmptyExpression()), addNullableConstraintBlock);
                    ifConstraintsPropertyIsNullBlockStatement.addStatement(ifPropertyIsAlreadyConstrainedStatement);
                }
            }
            BlockStatement methodBlockStatement = new BlockStatement();
            methodBlockStatement.addStatement(ifConstraintsPropertyIsNullStatement);
            ReturnStatement returnStatement = new ReturnStatement(new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME));
            methodBlockStatement.addStatement(returnStatement);
            MethodNode methodNode = new MethodNode("getConstraints", 9, new ClassNode(Map.class), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, methodBlockStatement);
            if (classNode.redirect() == null) {
                classNode.addMethod(methodNode);
                AnnotatedNodeUtils.markAsGenerated(classNode, methodNode);
            } else {
                classNode.redirect().addMethod(methodNode);
                AnnotatedNodeUtils.markAsGenerated(classNode.redirect(), methodNode);
            }
        }
    }

    protected Map<String, ClassNode> getPropertiesToEnsureConstraintsFor(ClassNode classNode) {
        HashMap<String, ClassNode> fieldsToConstrain = new HashMap<String, ClassNode>();
        List<FieldNode> allFields = classNode.getFields();
        for (FieldNode fieldNode : allFields) {
            PropertyNode propertyNode;
            if (fieldNode.isStatic() || (propertyNode = classNode.getProperty(fieldNode.getName())) == null) continue;
            fieldsToConstrain.put(fieldNode.getName(), fieldNode.getType());
        }
        Map<String, MethodNode> declaredMethodsMap = classNode.getDeclaredMethodsMap();
        for (Map.Entry<String, MethodNode> entry : declaredMethodsMap.entrySet()) {
            String methodName;
            Parameter[] parameters;
            MethodNode value = entry.getValue();
            if (value.isStatic() || !value.isPublic() || !classNode.equals(value.getDeclaringClass()) || value.getLineNumber() <= 0 || (parameters = value.getParameters()) != null && parameters.length != 0 || !(methodName = value.getName()).startsWith("get")) continue;
            ClassNode returnType = value.getReturnType();
            String restOfMethodName = methodName.substring(3);
            String propertyName = GrailsNameUtils.getPropertyName(restOfMethodName);
            fieldsToConstrain.put(propertyName, returnType);
        }
        ClassNode classNode2 = classNode.getSuperClass();
        if (!classNode2.equals(new ClassNode(Object.class))) {
            fieldsToConstrain.putAll(this.getPropertiesToEnsureConstraintsFor(classNode2));
        }
        return fieldsToConstrain;
    }

    protected void addValidateMethod(ClassNode classNode) {
        MethodNode noArgValidateMethod;
        String fieldsToValidateParameterName = "$fieldsToValidate";
        MethodNode listArgValidateMethod = classNode.getMethod(VALIDATE_METHOD_NAME, new Parameter[]{new Parameter(new ClassNode(List.class), fieldsToValidateParameterName)});
        if (listArgValidateMethod == null) {
            BlockStatement validateMethodCode = new BlockStatement();
            ArgumentListExpression validateInstanceArguments = new ArgumentListExpression();
            validateInstanceArguments.addExpression(new VariableExpression("this"));
            validateInstanceArguments.addExpression(new VariableExpression(fieldsToValidateParameterName, ClassHelper.LIST_TYPE));
            ClassNode validationSupportClassNode = ClassHelper.make(ValidationSupport.class);
            StaticMethodCallExpression invokeValidateInstanceExpression = new StaticMethodCallExpression(validationSupportClassNode, "validateInstance", validateInstanceArguments);
            validateMethodCode.addStatement(new ExpressionStatement(invokeValidateInstanceExpression));
            Parameter fieldsToValidateParameter = new Parameter(new ClassNode(List.class), fieldsToValidateParameterName);
            MethodNode methodNode = new MethodNode(VALIDATE_METHOD_NAME, 1, ClassHelper.boolean_TYPE, new Parameter[]{fieldsToValidateParameter}, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, validateMethodCode);
            classNode.addMethod(methodNode);
            AnnotatedNodeUtils.markAsGenerated(classNode, methodNode);
        }
        if ((noArgValidateMethod = classNode.getMethod(VALIDATE_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS)) == null) {
            BlockStatement validateMethodCode = new BlockStatement();
            ArgumentListExpression validateInstanceArguments = new ArgumentListExpression();
            validateInstanceArguments.addExpression(new CastExpression(new ClassNode(List.class), new ConstantExpression(null)));
            MethodCallExpression callListArgValidateMethod = new MethodCallExpression((Expression)new VariableExpression("this"), VALIDATE_METHOD_NAME, (Expression)validateInstanceArguments);
            validateMethodCode.addStatement(new ReturnStatement(callListArgValidateMethod));
            MethodNode methodNode = new MethodNode(VALIDATE_METHOD_NAME, 1, ClassHelper.boolean_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, validateMethodCode);
            classNode.addMethod(methodNode);
            AnnotatedNodeUtils.markAsGenerated(classNode, methodNode);
        }
    }
}

