/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import org.springframework.util.StringUtils;

public record PemSslStoreDetails(String type, String alias, String password, String certificates, String privateKey, String privateKeyPassword) {
    public PemSslStoreDetails(String type, String certificate, String privateKey, String privateKeyPassword) {
        this(type, null, null, certificate, privateKey, privateKeyPassword);
    }

    public PemSslStoreDetails(String type, String certificate, String privateKey) {
        this(type, certificate, privateKey, null);
    }

    public PemSslStoreDetails withAlias(String alias) {
        return new PemSslStoreDetails(this.type, alias, this.password, this.certificates, this.privateKey, this.privateKeyPassword);
    }

    public PemSslStoreDetails withPassword(String password) {
        return new PemSslStoreDetails(this.type, this.alias, password, this.certificates, this.privateKey, this.privateKeyPassword);
    }

    public PemSslStoreDetails withPrivateKey(String privateKey) {
        return new PemSslStoreDetails(this.type, this.alias, this.password, this.certificates, privateKey, this.privateKeyPassword);
    }

    public PemSslStoreDetails withPrivateKeyPassword(String privateKeyPassword) {
        return new PemSslStoreDetails(this.type, this.alias, this.password, this.certificates, this.privateKey, privateKeyPassword);
    }

    boolean isEmpty() {
        return this.isEmpty(this.type) && this.isEmpty(this.certificates) && this.isEmpty(this.privateKey);
    }

    private boolean isEmpty(String value) {
        return !StringUtils.hasText(value);
    }

    public static PemSslStoreDetails forCertificate(String certificate) {
        return PemSslStoreDetails.forCertificates(certificate);
    }

    public static PemSslStoreDetails forCertificates(String certificates) {
        return new PemSslStoreDetails(null, certificates, null);
    }
}

