/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.transactions.support;

import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringSessionSynchronization
implements TransactionSynchronization {
    private final SessionHolder sessionHolder;
    private final Datastore datastore;
    private final boolean newSession;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, Datastore datastore, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.datastore = datastore;
        this.newSession = newSession;
    }

    private Session getCurrentSession() {
        return this.sessionHolder.getSession();
    }

    @Override
    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource(this.datastore);
            this.getCurrentSession().disconnect();
        }
    }

    @Override
    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource(this.datastore, this.sessionHolder);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) throws DataAccessException {
    }

    @Override
    public void beforeCompletion() {
        if (this.newSession) {
            TransactionSynchronizationManager.unbindResource(this.datastore);
            this.holderActive = false;
        }
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterCompletion(int status) {
        Session session = this.sessionHolder.getSession();
        if (this.newSession) {
            DatastoreUtils.closeSessionOrRegisterDeferredClose(session, this.datastore);
        } else {
            session.disconnect();
        }
        if (this.sessionHolder.doesNotHoldNonDefaultSession()) {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

