/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractAnnotatedArgumentBinder;
import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.RequestBean;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RequestBeanAnnotationBinder<T>
extends AbstractAnnotatedArgumentBinder<RequestBean, T, HttpRequest<?>>
implements AnnotatedRequestArgumentBinder<RequestBean, T> {
    private final RequestBinderRegistry requestBinderRegistry;

    public RequestBeanAnnotationBinder(RequestBinderRegistry requestBinderRegistry, ConversionService<?> conversionService) {
        super(conversionService);
        this.requestBinderRegistry = requestBinderRegistry;
    }

    @Override
    public Class<RequestBean> getAnnotationType() {
        return RequestBean.class;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Argument<T> argument = context.getArgument();
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        boolean hasAnnotation = annotationMetadata.hasAnnotation(RequestBean.class);
        if (hasAnnotation) {
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(context.getArgument().getType());
            Map<String, BeanProperty> beanProperties = introspection.getBeanProperties().stream().collect(Collectors.toMap(Named::getName, p -> p));
            if (introspection.getConstructorArguments().length > 0) {
                Argument<?>[] constructorArguments = introspection.getConstructorArguments();
                Object[] argumentValues = new Object[constructorArguments.length];
                for (int i2 = 0; i2 < constructorArguments.length; ++i2) {
                    Argument<?> constructorArgument = constructorArguments[i2];
                    BeanProperty bp = beanProperties.get(constructorArgument.getName());
                    Argument<Object> argumentToBind = bp != null ? bp.asArgument() : constructorArgument;
                    Optional<Object> bindableResult = this.getBindableResult(source, argumentToBind);
                    argumentValues[i2] = constructorArgument.isOptional() ? bindableResult : bindableResult.orElse(null);
                }
                return () -> Optional.of(introspection.instantiate(false, argumentValues));
            }
            Object bean2 = introspection.instantiate();
            for (BeanProperty property : beanProperties.values()) {
                Argument<Object> propertyArgument = property.asArgument();
                Optional<Object> bindableResult = this.getBindableResult(source, propertyArgument);
                property.set(bean2, propertyArgument.isOptional() ? bindableResult : bindableResult.orElse(null));
            }
            return () -> Optional.of(bean2);
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }

    private Optional<Object> getBindableResult(HttpRequest<?> source, Argument<Object> argument) {
        ArgumentConversionContext<Object> conversionContext = ConversionContext.of(argument, source.getLocale().orElse(Locale.getDefault()), source.getCharacterEncoding());
        return this.getBindableResult(conversionContext, source);
    }

    private Optional<Object> getBindableResult(ArgumentConversionContext<Object> conversionContext, HttpRequest<?> source) {
        List<ConversionError> errors;
        Argument<Object> argument = conversionContext.getArgument();
        Optional<ArgumentBinder<Object, HttpRequest<?>>> binder = this.requestBinderRegistry.findArgumentBinder(argument, source);
        if (!binder.isPresent()) {
            throw new UnsatisfiedArgumentException(argument);
        }
        ArgumentBinder.BindingResult<Object> result = binder.get().bind(conversionContext, source);
        if (!(result.isSatisfied() && result.getConversionErrors().isEmpty() || (errors = result.getConversionErrors()).isEmpty())) {
            throw new ConversionErrorException(argument, errors.iterator().next());
        }
        if (!(result.isPresentAndSatisfied() || argument.isNullable() || argument.getType().isAssignableFrom(Optional.class))) {
            throw new UnsatisfiedArgumentException(argument);
        }
        return result.getValue();
    }
}

