/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.shared;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;

public abstract class NativeCalls {
    @Immutable
    protected static final NativeCalls instance;

    public static NativeCalls getInstance() {
        return instance;
    }

    public abstract String getEnvironment(String var1);

    public abstract int getProcessId();

    public abstract boolean isProcessActive(int var1) throws UnsupportedOperationException;

    public abstract boolean killProcess(int var1) throws UnsupportedOperationException;

    public void daemonize(RehashServerOnSIGHUP callback) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("daemonize() not available in base implementation");
    }

    public void preBlow(String path, long maxSize, boolean preAllocate) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
            raf.setLength(maxSize);
        }
    }

    public boolean isOnLocalFileSystem(String path) {
        return false;
    }

    static {
        NativeCalls inst;
        try {
            Class<?> c = Class.forName("org.apache.geode.internal.shared.NativeCallsJNAImpl");
            inst = (NativeCalls)c.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            inst = null;
        }
        if (inst == null) {
            inst = new NativeCallsGeneric();
        }
        instance = inst;
    }

    public static class NativeCallsGeneric
    extends NativeCalls {
        @Override
        public String getEnvironment(String name) {
            return System.getenv(name);
        }

        @Override
        public int getProcessId() {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int idx = name.indexOf(64);
            if (idx > 0) {
                try {
                    return Integer.parseInt(name.substring(0, idx));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }

        @Override
        public boolean isProcessActive(int processId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("isProcessActive() not available in generic implementation");
        }

        @Override
        public boolean killProcess(int processId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("killProcess() not available in generic implementation");
        }
    }

    public static interface RehashServerOnSIGHUP {
        public void rehash();
    }
}

