/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.offheap.RefCountChangeInfo;
import org.apache.geode.internal.offheap.ReferenceCountHelperImpl;

public class ReferenceCountHelper {
    private static final String TRACK_OFFHEAP_REFERENCES = "gemfire.trackOffHeapRefCounts";
    private static final String TRACK_OFFHEAP_FREES = "gemfire.trackOffHeapFreedRefCounts";
    @Immutable
    private static final ReferenceCountHelper INSTANCE = new ReferenceCountHelper(new ReferenceCountHelperImpl(Boolean.getBoolean("gemfire.trackOffHeapRefCounts"), Boolean.getBoolean("gemfire.trackOffHeapFreedRefCounts")));
    private final ReferenceCountHelperImpl delegate;

    private ReferenceCountHelper(ReferenceCountHelperImpl delegate) {
        this.delegate = delegate;
    }

    private static ReferenceCountHelperImpl delegate() {
        return ReferenceCountHelper.INSTANCE.delegate;
    }

    public static boolean trackReferenceCounts() {
        return ReferenceCountHelper.delegate().trackReferenceCounts();
    }

    static boolean trackFreedReferenceCounts() {
        return ReferenceCountHelper.delegate().trackFreedReferenceCounts();
    }

    public static void setReferenceCountOwner(Object owner) {
        ReferenceCountHelper.delegate().setReferenceCountOwner(owner);
    }

    public static Object createReferenceCountOwner() {
        return ReferenceCountHelper.delegate().createReferenceCountOwner();
    }

    public static void skipRefCountTracking() {
        ReferenceCountHelper.delegate().skipRefCountTracking();
    }

    public static boolean isRefCountTracking() {
        return ReferenceCountHelper.delegate().isRefCountTracking();
    }

    public static void unskipRefCountTracking() {
        ReferenceCountHelper.delegate().unskipRefCountTracking();
    }

    public static List<RefCountChangeInfo> getRefCountInfo(long address) {
        return ReferenceCountHelper.delegate().getRefCountInfo(address);
    }

    public static void refCountChanged(Long address, boolean decRefCount, int rc) {
        ReferenceCountHelper.delegate().refCountChanged(address, decRefCount, rc);
    }

    public static void freeRefCountInfo(Long address) {
        ReferenceCountHelper.delegate().freeRefCountInfo(address);
    }

    public static Object getReferenceCountOwner() {
        return ReferenceCountHelper.delegate().getReferenceCountOwner();
    }

    public static AtomicInteger getReenterCount() {
        return ReferenceCountHelper.delegate().getReenterCount();
    }

    public static List<RefCountChangeInfo> getFreeRefCountInfo(long address) {
        return ReferenceCountHelper.delegate().getFreeRefCountInfo(address);
    }

    public static List<RefCountChangeInfo> peekRefCountInfo(long address) {
        return ReferenceCountHelper.delegate().peekRefCountInfo(address);
    }
}

