/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CountingDataInputStream
implements DataInput,
AutoCloseable {
    private final long fileLength;
    private long count;
    private final DataInputStream dis;

    public CountingDataInputStream(InputStream is, long fileLength) {
        this.fileLength = fileLength;
        this.dis = new DataInputStream(is);
    }

    public long getCount() {
        return this.count;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void decrementCount() {
        --this.count;
    }

    public boolean atEndOfFile() {
        return this.fileLength == this.count;
    }

    @Override
    public void readFully(byte @NotNull [] b) throws IOException {
        this.dis.readFully(b);
        this.count += (long)b.length;
    }

    @Override
    public void readFully(byte @NotNull [] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
        this.count += (long)len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int result = this.dis.skipBytes(n);
        this.count += (long)result;
        return result;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean result = this.dis.readBoolean();
        ++this.count;
        return result;
    }

    @Override
    public byte readByte() throws IOException {
        byte result = this.dis.readByte();
        ++this.count;
        return result;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int result = this.dis.readUnsignedByte();
        ++this.count;
        return result;
    }

    @Override
    public short readShort() throws IOException {
        short result = this.dis.readShort();
        this.count += 2L;
        return result;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int result = this.dis.readUnsignedShort();
        this.count += 2L;
        return result;
    }

    @Override
    public char readChar() throws IOException {
        char result = this.dis.readChar();
        this.count += 2L;
        return result;
    }

    @Override
    public int readInt() throws IOException {
        int result = this.dis.readInt();
        this.count += 4L;
        return result;
    }

    @Override
    public long readLong() throws IOException {
        long result = this.dis.readLong();
        this.count += 8L;
        return result;
    }

    @Override
    public float readFloat() throws IOException {
        float result = this.dis.readFloat();
        this.count += 4L;
        return result;
    }

    @Override
    public double readDouble() throws IOException {
        double result = this.dis.readDouble();
        this.count += 8L;
        return result;
    }

    @Override
    public String readLine() throws IOException {
        throw new IllegalStateException("method not supported");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }
}

