/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisString;
import org.apache.geode.redis.internal.executor.StripedExecutor;
import org.apache.geode.redis.internal.executor.string.RedisStringCommandsFunctionInvoker;
import org.apache.geode.redis.internal.executor.string.SetOptions;
import org.apache.geode.redis.internal.netty.Coder;

public class NullRedisString
extends RedisString {
    public NullRedisString() {
        super(new ByteArrayWrapper(new byte[0]));
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    protected void valueAppend(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void valueSet(ByteArrayWrapper newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void valueSetBytes(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteArrayWrapper get() {
        return null;
    }

    @Override
    public int bitpos(Region<RedisKey, RedisData> region, RedisKey key, int bit, int start, Integer end) {
        if (bit == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public int setbit(Region<RedisKey, RedisData> region, RedisKey key, int bitValue, int byteIndex, byte bitIndex) {
        RedisString newValue;
        if (bitValue == 1) {
            byte[] bytes = new byte[byteIndex + 1];
            bytes[byteIndex] = (byte)(128 >> bitIndex);
            newValue = new RedisString(new ByteArrayWrapper(bytes));
        } else {
            newValue = new RedisString(new ByteArrayWrapper(new byte[0]));
        }
        region.put((Object)key, (Object)newValue);
        return 0;
    }

    @Override
    public long incr(Region<RedisKey, RedisData> region, RedisKey key) throws NumberFormatException, ArithmeticException {
        byte[] newValue = new byte[]{49};
        region.put((Object)key, (Object)new RedisString(new ByteArrayWrapper(newValue)));
        return 1L;
    }

    @Override
    public long incrby(Region<RedisKey, RedisData> region, RedisKey key, long increment) throws NumberFormatException, ArithmeticException {
        byte[] newValue = Coder.longToBytes(increment);
        region.put((Object)key, (Object)new RedisString(new ByteArrayWrapper(newValue)));
        return increment;
    }

    @Override
    public BigDecimal incrbyfloat(Region<RedisKey, RedisData> region, RedisKey key, BigDecimal increment) throws NumberFormatException, ArithmeticException {
        byte[] newValue = Coder.bigDecimalToBytes(increment);
        region.put((Object)key, (Object)new RedisString(new ByteArrayWrapper(newValue)));
        return increment;
    }

    @Override
    public long decr(Region<RedisKey, RedisData> region, RedisKey key) throws NumberFormatException, ArithmeticException {
        region.put((Object)key, (Object)new RedisString(new ByteArrayWrapper(Coder.stringToBytes("-1"))));
        return -1L;
    }

    @Override
    public long decrby(Region<RedisKey, RedisData> region, RedisKey key, long decrement) {
        byte[] newValue = Coder.longToBytes(-decrement);
        region.put((Object)key, (Object)new RedisString(new ByteArrayWrapper(newValue)));
        return -decrement;
    }

    @Override
    public int append(ByteArrayWrapper appendValue, Region<RedisKey, RedisData> region, RedisKey key) {
        region.put((Object)key, (Object)new RedisString(appendValue));
        return appendValue.length();
    }

    @Override
    public ByteArrayWrapper getset(Region<RedisKey, RedisData> region, RedisKey key, ByteArrayWrapper value) {
        region.put((Object)key, (Object)new RedisString(value));
        return null;
    }

    @Override
    public int setrange(Region<RedisKey, RedisData> region, RedisKey key, int offset, byte[] valueToAdd) {
        byte[] newBytes = valueToAdd;
        if (valueToAdd.length != 0) {
            if (offset != 0) {
                newBytes = new byte[offset + valueToAdd.length];
                System.arraycopy(valueToAdd, 0, newBytes, offset, valueToAdd.length);
            }
            region.put((Object)key, (Object)new RedisString(new ByteArrayWrapper(newBytes)));
        }
        return newBytes.length;
    }

    public boolean set(CommandHelper helper, RedisKey key, ByteArrayWrapper value, SetOptions options) {
        if (options != null) {
            if (options.isNX()) {
                return this.setnx(helper, key, value, options);
            }
            if (options.isXX() && helper.getRedisData(key).isNull()) {
                return false;
            }
        }
        RedisString redisString = helper.setRedisString(key, value);
        redisString.handleSetExpiration(options);
        return true;
    }

    private boolean setnx(CommandHelper helper, RedisKey key, ByteArrayWrapper value, SetOptions options) {
        if (helper.getRedisData(key).exists()) {
            return false;
        }
        RedisString redisString = new RedisString(value);
        redisString.handleSetExpiration(options);
        helper.getRegion().put((Object)key, (Object)redisString);
        return true;
    }

    public int bitop(CommandHelper helper, String operation, RedisKey key, List<RedisKey> sources) {
        ArrayList<ByteArrayWrapper> sourceValues = new ArrayList<ByteArrayWrapper>();
        int selfIndex = -1;
        RedisStringCommandsFunctionInvoker commander = new RedisStringCommandsFunctionInvoker(helper.getRegion());
        for (RedisKey sourceKey : sources) {
            if (sourceKey.equals(key)) {
                selfIndex = sourceValues.size();
                sourceValues.add(null);
                continue;
            }
            sourceValues.add(commander.get(sourceKey));
        }
        int indexOfSelf = selfIndex;
        StripedExecutor stripedExecutor = helper.getStripedExecutor();
        return stripedExecutor.execute(key, () -> this.doBitOp(helper, operation, key, indexOfSelf, sourceValues));
    }

    private int doBitOp(CommandHelper helper, String operation, RedisKey key, int selfIndex, List<ByteArrayWrapper> sourceValues) {
        ByteArrayWrapper newValue;
        RedisString redisString;
        if (selfIndex != -1 && !(redisString = helper.getRedisString(key, true)).isNull()) {
            sourceValues.set(selfIndex, redisString.getValue());
        }
        int maxLength = 0;
        for (ByteArrayWrapper sourceValue : sourceValues) {
            if (sourceValue == null || maxLength >= sourceValue.length()) continue;
            maxLength = sourceValue.length();
        }
        switch (operation) {
            case "AND": {
                newValue = this.doBitOp(BitOp.AND, sourceValues, maxLength);
                break;
            }
            case "OR": {
                newValue = this.doBitOp(BitOp.OR, sourceValues, maxLength);
                break;
            }
            case "XOR": {
                newValue = this.doBitOp(BitOp.XOR, sourceValues, maxLength);
                break;
            }
            default: {
                newValue = this.not(sourceValues.get(0), maxLength);
            }
        }
        if (newValue.length() == 0) {
            helper.getRegion().remove((Object)key);
        } else {
            helper.setRedisString(key, newValue);
        }
        return newValue.length();
    }

    private ByteArrayWrapper doBitOp(BitOp bitOp, List<ByteArrayWrapper> sourceValues, int max) {
        byte[] dest = new byte[max];
        for (int i = 0; i < max; ++i) {
            byte b = 0;
            boolean firstByte = true;
            for (ByteArrayWrapper sourceValue : sourceValues) {
                byte sourceByte = 0;
                if (sourceValue != null && i < sourceValue.length()) {
                    sourceByte = sourceValue.toBytes()[i];
                }
                if (firstByte) {
                    b = sourceByte;
                    firstByte = false;
                    continue;
                }
                switch (bitOp) {
                    case AND: {
                        b = (byte)(b & sourceByte);
                        break;
                    }
                    case OR: {
                        b = (byte)(b | sourceByte);
                        break;
                    }
                    case XOR: {
                        b = (byte)(b ^ sourceByte);
                    }
                }
            }
            dest[i] = b;
        }
        return new ByteArrayWrapper(dest);
    }

    private ByteArrayWrapper not(ByteArrayWrapper sourceValue, int max) {
        byte[] dest = new byte[max];
        if (sourceValue == null) {
            for (int i = 0; i < max; ++i) {
                dest[i] = -1;
            }
        } else {
            byte[] cA = sourceValue.toBytes();
            for (int i = 0; i < max; ++i) {
                dest[i] = (byte)(~cA[i] & 0xFF);
            }
        }
        return new ByteArrayWrapper(dest);
    }

    private static enum BitOp {
        AND,
        OR,
        XOR;

    }
}

