/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Set;
import joptsimple.internal.Strings;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportClusterConfigurationCommand
extends GfshCommand {
    private static final Logger logger = LogService.getLogger();
    public static final String XML_FILE = "xml-file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"export cluster-configuration"}, help="Exports the cluster configuration artifacts as a zip file.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportClusterConfigurationCommand$ExportInterceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel exportSharedConfig(@CliOption(key={"group"}, specifiedDefaultValue="cluster", unspecifiedDefaultValue="cluster") String group, @CliOption(key={"xml-file"}) String xmlFile, @CliOption(key={"zip-file-name"}, help="Path to the zip file containing the exported cluster configuration artifacts") String zipFileName) throws IOException {
        if (!this.isSharedConfigurationRunning()) {
            return ResultModel.createError("Cluster configuration service is not running.");
        }
        ResultModel result = new ResultModel();
        InternalConfigurationPersistenceService configPersistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (zipFileName != null) {
            Path tempDir = Files.createTempDirectory("temp", new FileAttribute[0]);
            Path exportedDir = tempDir.resolve("cluster_config");
            Path zipFile = tempDir.resolve(FilenameUtils.getName((String)zipFileName));
            try {
                for (Configuration config : configPersistenceService.getEntireConfiguration().values()) {
                    configPersistenceService.writeConfigToFile(config, exportedDir.toFile());
                }
                ZipUtils.zipDirectory((Path)exportedDir, (Path)zipFile);
                result.addFile(zipFile.toFile(), 0);
            }
            catch (Exception e) {
                logger.error("unable to export configuration.", (Throwable)e);
            }
            finally {
                FileUtils.deleteQuietly((File)tempDir.toFile());
            }
        } else {
            Set jarNames;
            Properties gemfireProperties;
            Configuration configuration = configPersistenceService.getConfiguration(group);
            if (configuration == null) {
                return ResultModel.createError("No cluster configuration for '" + group + "'.");
            }
            String cacheXmlContent = configuration.getCacheXmlContent();
            if (cacheXmlContent != null) {
                InfoResultModel xmlSection = result.addInfo("xml");
                xmlSection.setHeader(configuration.getCacheXmlFileName() + ": ");
                xmlSection.addLine(cacheXmlContent);
            }
            if ((gemfireProperties = configuration.getGemfireProperties()).size() > 0) {
                DataResultModel propertySection = result.addData("properties");
                propertySection.setHeader("Properties: ");
                propertySection.addData(gemfireProperties);
            }
            if ((jarNames = configuration.getJarNames()).size() > 0) {
                InfoResultModel jarSection = result.addInfo("jars");
                jarSection.setHeader("Jars: ");
                jarSection.addLine(Strings.join((Iterable)jarNames, (String)", "));
            }
        }
        return result;
    }

    public static class ExportInterceptor
    extends AbstractCliAroundInterceptor {
        private String saveDirString;
        private static final Logger logger = LogService.getLogger();

        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String message;
            File file;
            String exportedFile;
            String zip = parseResult.getParamValueAsString("zip-file-name");
            String xmlFile = parseResult.getParamValueAsString(ExportClusterConfigurationCommand.XML_FILE);
            String group = parseResult.getParamValueAsString("group");
            if (group != null && group.contains(",")) {
                return ResultModel.createError("Only a single group name is supported.");
            }
            if (zip != null && xmlFile != null) {
                return ResultModel.createError("Zip file and xml File can't both be specified.");
            }
            if (zip != null && !group.equals("cluster")) {
                return ResultModel.createError("zip file can not be exported with a specific group.");
            }
            if (zip != null && !zip.endsWith(".zip")) {
                return ResultModel.createError(CliStrings.format((String)"Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            String string = exportedFile = zip != null ? zip : xmlFile;
            if (exportedFile != null && (file = new File(exportedFile).getAbsoluteFile()).exists() && this.readYesNo(message = file.getAbsolutePath() + " already exists. Overwrite it? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultModel.createError("Aborted. " + exportedFile + "already exists.");
            }
            return ResultModel.createInfo("");
        }

        @Override
        public ResultModel postExecution(GfshParseResult parseResult, ResultModel result, Path tempFile) throws IOException {
            if (result.getStatus() == Result.Status.ERROR) {
                return result;
            }
            String xmlFile = parseResult.getParamValueAsString(ExportClusterConfigurationCommand.XML_FILE);
            String zipFile = parseResult.getParamValueAsString("zip-file-name");
            String group = parseResult.getParamValueAsString("group");
            if (xmlFile != null) {
                InfoResultModel xmlSection = result.getInfoSection("xml");
                if (xmlSection == null) {
                    InfoResultModel info = result.addInfo("info");
                    info.addLine(String.format("xml content is empty. %s is not created.", xmlFile));
                } else {
                    File file = new File(xmlFile).getAbsoluteFile();
                    FileUtils.write((File)file, (CharSequence)Strings.join((Iterable)xmlSection.getContent(), (String)System.lineSeparator()), (Charset)Charset.defaultCharset());
                    xmlSection.removeLine(0);
                    xmlSection.addLine("xml content exported to " + file.getAbsolutePath());
                }
            } else if (zipFile != null) {
                File file = new File(zipFile).getAbsoluteFile();
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                result.saveFileTo(file.getParentFile());
            }
            return result;
        }
    }
}

