/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.chat;

import com.fasterxml.jackson.annotation.JsonValue;
import io.github.ollama4j.exceptions.RoleNotFoundException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class OllamaChatMessageRole {
    private static final List<OllamaChatMessageRole> roles = new ArrayList<OllamaChatMessageRole>();
    public static final OllamaChatMessageRole SYSTEM = new OllamaChatMessageRole("system");
    public static final OllamaChatMessageRole USER = new OllamaChatMessageRole("user");
    public static final OllamaChatMessageRole ASSISTANT = new OllamaChatMessageRole("assistant");
    public static final OllamaChatMessageRole TOOL = new OllamaChatMessageRole("tool");
    @JsonValue
    private final String roleName;

    private OllamaChatMessageRole(String roleName) {
        this.roleName = roleName;
        roles.add(this);
    }

    public static OllamaChatMessageRole newCustomRole(String roleName) {
        return new OllamaChatMessageRole(roleName);
    }

    public static List<OllamaChatMessageRole> getRoles() {
        return new ArrayList<OllamaChatMessageRole>(roles);
    }

    public static OllamaChatMessageRole getRole(String roleName) throws RoleNotFoundException {
        for (OllamaChatMessageRole role : roles) {
            if (!role.roleName.equals(roleName)) continue;
            return role;
        }
        throw new RoleNotFoundException("Invalid role name: " + roleName);
    }

    public String toString() {
        return this.roleName;
    }

    @Generated
    public String getRoleName() {
        return this.roleName;
    }
}

