/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import java.util.function.Predicate;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtils;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.calc.async.RetryPredicates;

public class AsyncScalarUtil
extends FunctionCallUtils {
    public static boolean containsAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(true, true));
    }

    public static boolean containsNonAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(false, true));
    }

    public static boolean isAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(true, false));
    }

    public static boolean isNonAsyncCall(RexNode node) {
        return node.accept(new FunctionFinder(false, false));
    }

    public static FunctionCallUtils.AsyncOptions getAsyncOptions(ExecNodeConfig config) {
        return new FunctionCallUtils.AsyncOptions((Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_BUFFER_CAPACITY), ((Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_TIMEOUT)).toMillis(), false, AsyncDataStream.OutputMode.ORDERED);
    }

    public static AsyncRetryStrategy<RowData> getResultRetryStrategy(ExecNodeConfig config) {
        ExecutionConfigOptions.RetryStrategy retryStrategy = (ExecutionConfigOptions.RetryStrategy)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_RETRY_STRATEGY);
        Duration retryDelay = (Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_RETRY_DELAY);
        int retryMaxAttempts = (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_SCALAR_MAX_ATTEMPTS);
        if (retryStrategy == ExecutionConfigOptions.RetryStrategy.FIXED_DELAY) {
            return new AsyncRetryStrategies.FixedDelayRetryStrategyBuilder(retryMaxAttempts, retryDelay.toMillis()).ifResult((Predicate)RetryPredicates.EMPTY_RESPONSE).ifException(RetryPredicates.ANY_EXCEPTION).build();
        }
        return AsyncRetryStrategies.NO_RETRY_STRATEGY;
    }

    private static class FunctionFinder
    extends RexDefaultVisitor<Boolean> {
        private final boolean findAsyncCall;
        private final boolean recursive;

        public FunctionFinder(boolean findAsyncCall, boolean recursive) {
            this.findAsyncCall = findAsyncCall;
            this.recursive = recursive;
        }

        @Override
        public Boolean visitNode(RexNode rexNode) {
            return false;
        }

        private boolean isImmediateAsyncCall(RexCall call) {
            FunctionDefinition definition = ShortcutUtils.unwrapFunctionDefinition(call);
            return definition != null && definition.getKind() == FunctionKind.ASYNC_SCALAR;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            boolean isImmediateAsyncCall = this.isImmediateAsyncCall(call);
            return this.findAsyncCall == isImmediateAsyncCall || this.recursive && call.getOperands().stream().anyMatch(node -> node.accept(this));
        }
    }
}

