/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.batch.WindowCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.groupwindow.RowtimeAttribute;
import org.apache.flink.table.runtime.groupwindow.WindowEnd;
import org.apache.flink.table.runtime.groupwindow.WindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowStart;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecPythonGroupWindowAggregate
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final String ARROW_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.BatchArrowPythonGroupWindowAggregateFunctionOperator";
    private final int[] grouping;
    private final int[] auxGrouping;
    private final AggregateCall[] aggCalls;
    private final LogicalWindow window;
    private final int inputTimeFieldIndex;
    private final NamedWindowProperty[] namedWindowProperties;

    public BatchExecPythonGroupWindowAggregate(ReadableConfig tableConfig, int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, LogicalWindow window, int inputTimeFieldIndex, NamedWindowProperty[] namedWindowProperties, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecPythonGroupWindowAggregate.class), ExecNodeContext.newPersistedConfig(BatchExecPythonGroupWindowAggregate.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.window = window;
        this.inputTimeFieldIndex = inputTimeFieldIndex;
        this.namedWindowProperties = namedWindowProperties;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType();
        Tuple2<Long, Long> windowSizeAndSlideSize = WindowCodeGenerator.getWindowDef(this.window);
        Configuration pythonConfig = CommonPythonUtil.extractPythonConfiguration((ReadableConfig)planner.getTableConfig(), planner.getFlinkContext().getClassLoader());
        int groupBufferLimitSize = (Integer)pythonConfig.get(ExecutionConfigOptions.TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMIT);
        OneInputTransformation<RowData, RowData> transform = this.createPythonOneInputTransformation(inputTransform, inputRowType, outputRowType, groupBufferLimitSize, (Long)windowSizeAndSlideSize.f0, (Long)windowSizeAndSlideSize.f1, pythonConfig, config, planner.getFlinkContext().getClassLoader());
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(pythonConfig, planner.getFlinkContext().getClassLoader())) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        return transform;
    }

    private OneInputTransformation<RowData, RowData> createPythonOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, int maxLimitSize, long windowSize, long slideSize, Configuration pythonConfig, ExecNodeConfig config, ClassLoader classLoader) {
        int[] namePropertyTypeArray = Arrays.stream(this.namedWindowProperties).mapToInt(p -> {
            WindowProperty property = p.getProperty();
            if (property instanceof WindowStart) {
                return 0;
            }
            if (property instanceof WindowEnd) {
                return 1;
            }
            if (property instanceof RowtimeAttribute) {
                return 2;
            }
            throw new TableException("Unexpected property " + String.valueOf(property));
        }).toArray();
        Tuple2<int[], PythonFunctionInfo[]> aggInfos = CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall(this.aggCalls);
        int[] pythonUdafInputOffsets = (int[])aggInfos.f0;
        PythonFunctionInfo[] pythonFunctionInfos = (PythonFunctionInfo[])aggInfos.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPythonGroupWindowAggregateFunctionOperator(config, classLoader, pythonConfig, inputRowType, outputRowType, maxLimitSize, windowSize, slideSize, namePropertyTypeArray, pythonUdafInputOffsets, pythonFunctionInfos);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), pythonOperator, InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), false);
    }

    private OneInputStreamOperator<RowData, RowData> getPythonGroupWindowAggregateFunctionOperator(ExecNodeConfig config, ClassLoader classLoader, Configuration pythonConfig, RowType inputRowType, RowType outputRowType, int maxLimitSize, long windowSize, long slideSize, int[] namePropertyTypeArray, int[] udafInputOffsets, PythonFunctionInfo[] pythonFunctionInfos) {
        Class<?> clazz = CommonPythonUtil.loadClass(ARROW_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME, classLoader);
        RowType udfInputType = (RowType)Projection.of((int[])udafInputOffsets).project((LogicalType)inputRowType);
        RowType udfOutputType = (RowType)Projection.range((int)this.auxGrouping.length, (int)(outputRowType.getFieldCount() - namePropertyTypeArray.length)).project((LogicalType)outputRowType);
        try {
            Constructor<?> ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo[].class, RowType.class, RowType.class, RowType.class, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, int[].class, GeneratedProjection.class, GeneratedProjection.class, GeneratedProjection.class);
            return (OneInputStreamOperator)ctor.newInstance(pythonConfig, pythonFunctionInfos, inputRowType, udfInputType, udfOutputType, this.inputTimeFieldIndex, maxLimitSize, windowSize, slideSize, namePropertyTypeArray, ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "UdafInputProjection", inputRowType, udfInputType, udafInputOffsets), ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "GroupKey", inputRowType, (RowType)Projection.of((int[])this.grouping).project((LogicalType)inputRowType), this.grouping), ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "GroupSet", inputRowType, (RowType)Projection.of((int[])this.auxGrouping).project((LogicalType)inputRowType), this.auxGrouping));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python BatchArrowPythonGroupWindowAggregateFunctionOperator constructed failed.", (Throwable)e);
        }
    }
}

