/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.lineage;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.lineage.LineageDataset;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.LineageVertexProvider;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.operations.ModifyType;
import org.apache.flink.table.planner.lineage.TableLineageDatasetImpl;
import org.apache.flink.types.RowKind;

public class TableLineageUtils {
    public static Optional<LineageVertex> extractLineageDataset(@Nullable Object object) {
        if (object != null && object instanceof LineageVertexProvider) {
            return Optional.of(((LineageVertexProvider)object).getLineageVertex());
        }
        return Optional.empty();
    }

    public static LineageDataset createTableLineageDataset(ContextResolvedTable contextResolvedTable, Optional<LineageVertex> lineageDataset) {
        String name = contextResolvedTable.getIdentifier().asSummaryString();
        TableLineageDatasetImpl tableLineageDataset = new TableLineageDatasetImpl(contextResolvedTable, TableLineageUtils.findLineageDataset(name, lineageDataset));
        return tableLineageDataset;
    }

    public static ModifyType convert(ChangelogMode inputChangelogMode) {
        if (inputChangelogMode.containsOnly(RowKind.INSERT)) {
            return ModifyType.INSERT;
        }
        if (inputChangelogMode.containsOnly(RowKind.DELETE)) {
            return ModifyType.DELETE;
        }
        return ModifyType.UPDATE;
    }

    private static Optional<LineageDataset> findLineageDataset(String name, Optional<LineageVertex> lineageVertexOpt) {
        if (lineageVertexOpt.isPresent()) {
            LineageVertex lineageVertex = lineageVertexOpt.get();
            if (lineageVertex.datasets().size() == 1) {
                return Optional.of((LineageDataset)lineageVertex.datasets().get(0));
            }
            for (LineageDataset dataset : lineageVertex.datasets()) {
                if (!dataset.name().equals(name)) continue;
                return Optional.of(dataset);
            }
        }
        return Optional.empty();
    }

    private static Map<String, String> extractOptions(CatalogBaseTable catalogBaseTable) {
        try {
            return catalogBaseTable.getOptions();
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }
}

