/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;

@Internal
final class FunctionSignatureTemplate {
    final List<FunctionArgumentTemplate> argumentTemplates;
    final boolean isVarArgs;
    final EnumSet<StaticArgumentTrait>[] argumentTraits;
    final String[] argumentNames;
    final boolean[] argumentOptionals;

    private FunctionSignatureTemplate(List<FunctionArgumentTemplate> argumentTemplates, boolean isVarArgs, EnumSet<StaticArgumentTrait>[] argumentTraits, @Nullable String[] argumentNames, boolean[] argumentOptionals) {
        this.argumentTemplates = argumentTemplates;
        this.isVarArgs = isVarArgs;
        this.argumentTraits = argumentTraits;
        this.argumentNames = argumentNames == null ? (String[])IntStream.range(0, argumentTemplates.size()).mapToObj(pos -> "arg" + pos).toArray(String[]::new) : argumentNames;
        this.argumentOptionals = argumentOptionals;
    }

    static FunctionSignatureTemplate of(List<FunctionArgumentTemplate> argumentTemplates, boolean isVarArgs, EnumSet<StaticArgumentTrait>[] argumentTraits, @Nullable String[] argumentNames, boolean[] argumentOptionals) {
        if (argumentNames != null && argumentNames.length != argumentTemplates.size()) {
            throw ExtractionUtils.extractionError("Mismatch between number of argument names '%s' and argument types '%s'.", argumentNames.length, argumentTemplates.size());
        }
        if (argumentNames != null && (long)argumentNames.length != Arrays.stream(argumentNames).distinct().count()) {
            throw ExtractionUtils.extractionError("Argument name conflict, there are at least two argument names that are the same.", new Object[0]);
        }
        if (argumentOptionals != null && argumentOptionals.length != argumentTemplates.size()) {
            throw ExtractionUtils.extractionError("Mismatch between number of argument optionals '%s' and argument types '%s'.", argumentOptionals.length, argumentTemplates.size());
        }
        if (argumentOptionals != null) {
            for (int i = 0; i < argumentTemplates.size(); ++i) {
                DataType dataType = argumentTemplates.get(i).toDataType();
                if (dataType == null || dataType.getLogicalType().isNullable() || !argumentOptionals[i]) continue;
                throw ExtractionUtils.extractionError("Argument at position %s is optional but its type doesn't accept null value.", i);
            }
        }
        return new FunctionSignatureTemplate(argumentTemplates, isVarArgs, argumentTraits, argumentNames, argumentOptionals);
    }

    @Nullable
    List<StaticArgument> toStaticArguments() {
        if (this.isVarArgs || this.argumentNames == null) {
            return null;
        }
        List<StaticArgument> arguments = IntStream.range(0, this.argumentTemplates.size()).mapToObj(pos -> {
            String name = this.argumentNames[pos];
            boolean isOptional = this.argumentOptionals[pos];
            FunctionArgumentTemplate template = this.argumentTemplates.get(pos);
            EnumSet<StaticArgumentTrait> traits = this.argumentTraits[pos];
            if (traits.contains((Object)StaticArgumentTrait.TABLE_AS_ROW) || traits.contains((Object)StaticArgumentTrait.TABLE_AS_SET)) {
                return FunctionSignatureTemplate.createTableArgument(name, isOptional, traits, template.toDataType(), template.toConversionClass());
            }
            if (traits.contains((Object)StaticArgumentTrait.SCALAR)) {
                return FunctionSignatureTemplate.createScalarArgument(name, isOptional, template.toDataType());
            }
            return null;
        }).collect(Collectors.toList());
        if (arguments.contains(null)) {
            return null;
        }
        return arguments;
    }

    @Nullable
    private static StaticArgument createTableArgument(String name, boolean isOptional, EnumSet<StaticArgumentTrait> traits, @Nullable DataType dataType, @Nullable Class<?> conversionClass) {
        if (dataType != null) {
            return StaticArgument.table(name, dataType, isOptional, traits);
        }
        if (conversionClass != null) {
            return StaticArgument.table(name, conversionClass, isOptional, traits);
        }
        return null;
    }

    @Nullable
    private static StaticArgument createScalarArgument(String name, boolean isOptional, @Nullable DataType dataType) {
        if (dataType != null) {
            return StaticArgument.scalar(name, dataType, isOptional);
        }
        return null;
    }

    InputTypeStrategy toInputTypeStrategy() {
        ArgumentTypeStrategy[] argumentStrategies = (ArgumentTypeStrategy[])this.argumentTemplates.stream().map(FunctionArgumentTemplate::toArgumentTypeStrategy).toArray(ArgumentTypeStrategy[]::new);
        InputTypeStrategy strategy = this.isVarArgs ? (this.argumentNames == null ? InputTypeStrategies.varyingSequence(argumentStrategies) : InputTypeStrategies.varyingSequence(this.argumentNames, argumentStrategies)) : (this.argumentNames == null ? InputTypeStrategies.sequence(argumentStrategies) : InputTypeStrategies.sequence(this.argumentNames, argumentStrategies));
        return strategy;
    }

    List<Class<?>> toClassList() {
        return IntStream.range(0, this.argumentTemplates.size()).mapToObj(i -> {
            Class<?> clazz = this.argumentTemplates.get(i).toConversionClass();
            if (i == this.argumentTemplates.size() - 1 && this.isVarArgs) {
                return Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionSignatureTemplate that = (FunctionSignatureTemplate)o;
        return this.isVarArgs == that.isVarArgs && this.argumentTemplates.equals(that.argumentTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.argumentTemplates, this.isVarArgs);
    }
}

